/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorValueSelector;

public class LongVectorValueMatcher
implements VectorValueMatcherFactory {
    private final VectorValueSelector selector;

    public LongVectorValueMatcher(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        if (value == null) {
            return VectorValueMatcher.nullMatcher(this.selector);
        }
        Long matchVal = DimensionHandlerUtils.convertObjectToLong(value);
        if (matchVal == null) {
            return VectorValueMatcher.allFalseValueMatcher(this.selector);
        }
        long matchValLong = matchVal;
        return this.makeLongMatcher(matchValLong);
    }

    @Override
    public VectorValueMatcher makeMatcher(Object matchValue, ColumnType matchValueType) {
        ExprEval eval = ExprEval.ofType(ExpressionType.fromColumnType(matchValueType), matchValue);
        ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.LONG);
        if (castForComparison == null || castForComparison.isNumericNull()) {
            return VectorValueMatcher.allFalseValueMatcher(this.selector);
        }
        return this.makeLongMatcher(castForComparison.asLong());
    }

    private BaseVectorValueMatcher makeLongMatcher(final long matchValLong) {
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[LongVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                long[] vector = LongVectorValueMatcher.this.selector.getLongVector();
                int[] selection = this.match.getSelection();
                boolean[] nulls = LongVectorValueMatcher.this.selector.getNullVector();
                boolean hasNulls = nulls != null;
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (hasNulls && nulls[rowNum]) {
                        if (!includeUnknown) continue;
                        selection[numRows++] = rowNum;
                        continue;
                    }
                    if (vector[rowNum] != matchValLong) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }

    @Override
    public VectorValueMatcher makeMatcher(final DruidPredicateFactory predicateFactory) {
        final DruidLongPredicate predicate = predicateFactory.makeLongPredicate();
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[LongVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                long[] vector = LongVectorValueMatcher.this.selector.getLongVector();
                int[] selection = this.match.getSelection();
                boolean[] nulls = LongVectorValueMatcher.this.selector.getNullVector();
                boolean hasNulls = nulls != null;
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (hasNulls && nulls[rowNum]) {
                        if ((!includeUnknown || !predicateFactory.isNullInputUnknown()) && !predicate.applyNull()) continue;
                        selection[numRows++] = rowNum;
                        continue;
                    }
                    if (!predicate.applyLong(vector[rowNum])) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }
}

