/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import com.google.common.base.Predicate;
import java.util.BitSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;

public class MultiValueStringVectorValueMatcher
implements VectorValueMatcherFactory {
    private final MultiValueDimensionVectorSelector selector;

    public MultiValueStringVectorValueMatcher(MultiValueDimensionVectorSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        final String etnValue = NullHandling.emptyToNullIfNeeded(value);
        IdLookup idLookup = this.selector.idLookup();
        if (idLookup != null) {
            final int id = idLookup.lookupId(etnValue);
            final boolean hasNull = NullHandling.isNullOrEquivalent(this.selector.lookupName(0));
            if (id < 0) {
                return VectorValueMatcher.allFalseMultiValueDimensionMatcher(this.selector);
            }
            return new BaseVectorValueMatcher(this.selector){
                final VectorMatch match;
                {
                    super(selector);
                    this.match = VectorMatch.wrap(new int[MultiValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
                }

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                    IndexedInts[] vector = MultiValueStringVectorValueMatcher.this.selector.getRowVector();
                    int[] selection = this.match.getSelection();
                    int numRows = 0;
                    block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        int rowNum = mask.getSelection()[i];
                        IndexedInts ints = vector[rowNum];
                        int n = ints.size();
                        if (n == 0) {
                            if (etnValue != null && !includeUnknown) continue;
                            selection[numRows++] = rowNum;
                            continue;
                        }
                        for (int j = 0; j < n; ++j) {
                            int rowId = ints.get(j);
                            if ((!hasNull || !includeUnknown || rowId != 0) && rowId != id) continue;
                            selection[numRows++] = rowNum;
                            continue block0;
                        }
                    }
                    this.match.setSelectionSize(numRows);
                    return this.match;
                }
            };
        }
        return this.makeMatcher((Predicate<String>)((Predicate)s -> Objects.equals(s, etnValue)), true);
    }

    @Override
    public VectorValueMatcher makeMatcher(Object matchValue, ColumnType matchValueType) {
        ExprEval eval = ExprEval.ofType(ExpressionType.fromColumnType(matchValueType), matchValue);
        ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.STRING);
        if (castForComparison == null) {
            return VectorValueMatcher.allFalseMultiValueDimensionMatcher(this.selector);
        }
        return this.makeMatcher(castForComparison.asString());
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        return this.makeMatcher(predicateFactory.makeStringPredicate(), predicateFactory.isNullInputUnknown());
    }

    private VectorValueMatcher makeMatcher(final Predicate<String> predicate, final boolean isNullInputUnknown) {
        final boolean matchNull = predicate.apply(null);
        if (this.selector.getValueCardinality() > 0) {
            final BitSet checkedIds = new BitSet(this.selector.getValueCardinality());
            final BitSet matchingIds = new BitSet(this.selector.getValueCardinality());
            return new BaseVectorValueMatcher(this.selector){
                private final VectorMatch match;
                {
                    super(selector);
                    this.match = VectorMatch.wrap(new int[MultiValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
                }

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                    IndexedInts[] vector = MultiValueStringVectorValueMatcher.this.selector.getRowVector();
                    int[] selection = this.match.getSelection();
                    boolean includeNulls = includeUnknown && isNullInputUnknown;
                    int numRows = 0;
                    block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        int rowNum = mask.getSelection()[i];
                        IndexedInts ints = vector[rowNum];
                        int n = ints.size();
                        if (n == 0) {
                            if (!matchNull && !includeNulls) continue;
                            selection[numRows++] = rowNum;
                            continue;
                        }
                        for (int j = 0; j < n; ++j) {
                            boolean matches;
                            int id = ints.get(j);
                            if (checkedIds.get(id)) {
                                matches = matchingIds.get(id);
                            } else {
                                String val = MultiValueStringVectorValueMatcher.this.selector.lookupName(id);
                                matches = includeNulls && val == null || predicate.apply((Object)val);
                                checkedIds.set(id);
                                if (matches) {
                                    matchingIds.set(id);
                                }
                            }
                            if (!matches) continue;
                            selection[numRows++] = rowNum;
                            continue block0;
                        }
                    }
                    this.match.setSelectionSize(numRows);
                    return this.match;
                }
            };
        }
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[MultiValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                boolean includeNulls = includeUnknown && isNullInputUnknown;
                IndexedInts[] vector = MultiValueStringVectorValueMatcher.this.selector.getRowVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    IndexedInts ints = vector[rowNum];
                    int n = ints.size();
                    if (n == 0) {
                        if (!matchNull && !includeNulls) continue;
                        selection[numRows++] = rowNum;
                        continue;
                    }
                    for (int j = 0; j < n; ++j) {
                        int id = ints.get(j);
                        String val = MultiValueStringVectorValueMatcher.this.selector.lookupName(id);
                        if ((!includeNulls || val != null) && !predicate.apply((Object)val)) continue;
                        selection[numRows++] = rowNum;
                        continue block0;
                    }
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }
}

