/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.having.HavingSpec;

public class NotHavingSpec
implements HavingSpec {
    private final HavingSpec havingSpec;

    @JsonCreator
    public NotHavingSpec(@JsonProperty(value="havingSpec") HavingSpec havingSpec) {
        this.havingSpec = havingSpec;
    }

    @JsonProperty(value="havingSpec")
    public HavingSpec getHavingSpec() {
        return this.havingSpec;
    }

    @Override
    public void setQuery(GroupByQuery query) {
        this.havingSpec.setQuery(query);
    }

    @Override
    public boolean eval(ResultRow row) {
        return !this.havingSpec.eval(row);
    }

    public String toString() {
        return "NotHavingSpec{havingSpec=" + this.havingSpec + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotHavingSpec that = (NotHavingSpec)o;
        return !(this.havingSpec != null ? !this.havingSpec.equals(that.havingSpec) : that.havingSpec != null);
    }

    public int hashCode() {
        return this.havingSpec != null ? this.havingSpec.hashCode() : 0;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(8).appendCacheable(this.havingSpec).build();
    }
}

