/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.io.Closeable;
import java.io.IOException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.Segment;

public class SegmentToRowsAndColumnsOperator
implements Operator {
    private final Segment segment;

    public SegmentToRowsAndColumnsOperator(Segment segment) {
        this.segment = segment;
    }

    @Override
    public Closeable goOrContinue(Closeable continuation, Operator.Receiver receiver) {
        try (CloseableShapeshifter shifty = this.segment.as(CloseableShapeshifter.class);){
            if (shifty == null) {
                throw new ISE("Segment[%s] cannot shapeshift", this.segment.getClass());
            }
            RowsAndColumns rac = shifty instanceof RowsAndColumns ? (RowsAndColumns)((Object)shifty) : shifty.as(RowsAndColumns.class);
            if (rac == null) {
                throw new ISE("Cannot work with segment of type[%s]", this.segment.getClass());
            }
            receiver.push(rac);
            receiver.completed();
        }
        catch (IOException e) {
            throw new RE(e, "Problem closing resources for segment[%s]", this.segment.getId());
        }
        return null;
    }
}

