/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.rowsandcols.ArrayListRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedStorageAdapter;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class ArrayListSegment<RowType>
implements Segment {
    private final SegmentId segmentId;
    private final ArrayList<RowType> rows;
    private final RowAdapter<RowType> rowAdapter;
    private final RowSignature rowSignature;

    public ArrayListSegment(SegmentId segmentId, ArrayList<RowType> rows, RowAdapter<RowType> rowAdapter, RowSignature rowSignature) {
        this.segmentId = (SegmentId)Preconditions.checkNotNull((Object)segmentId, (Object)"segmentId");
        this.rows = rows;
        this.rowAdapter = rowAdapter;
        this.rowSignature = rowSignature;
    }

    @Override
    @Nonnull
    public SegmentId getId() {
        return this.segmentId;
    }

    @Override
    @Nonnull
    public Interval getDataInterval() {
        return Intervals.ETERNITY;
    }

    @Override
    @Nullable
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    @Nonnull
    public StorageAdapter asStorageAdapter() {
        return new RowBasedStorageAdapter<RowType>(Sequences.simple(this.rows), this.rowAdapter, this.rowSignature);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (CloseableShapeshifter.class.equals(clazz)) {
            return (T)new MyCloseableShapeshifter();
        }
        return null;
    }

    @Override
    public void close() {
    }

    private RowsAndColumns asRowsAndColumns() {
        return new ArrayListRowsAndColumns<RowType>(this.rows, this.rowAdapter, this.rowSignature);
    }

    private class MyCloseableShapeshifter
    implements CloseableShapeshifter {
        private MyCloseableShapeshifter() {
        }

        @Override
        public void close() {
        }

        @Override
        @Nullable
        public <T> T as(Class<T> clazz) {
            if (RowsAndColumns.class.equals(clazz)) {
                return (T)ArrayListSegment.this.asRowsAndColumns();
            }
            return null;
        }
    }
}

