/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;

public class DefaultColumnFormatConfig {
    @JsonProperty(value="nestedColumnFormatVersion")
    private final Integer nestedColumnFormatVersion;

    public static void validateNestedFormatVersion(@Nullable Integer formatVersion) {
        if (formatVersion != null && (formatVersion < 4 || formatVersion > 5)) {
            throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Unsupported nested column format version[%s]", formatVersion);
        }
    }

    @JsonCreator
    public DefaultColumnFormatConfig(@JsonProperty(value="nestedColumnFormatVersion") @Nullable Integer nestedColumnFormatVersion) {
        this.nestedColumnFormatVersion = nestedColumnFormatVersion;
        DefaultColumnFormatConfig.validateNestedFormatVersion(this.nestedColumnFormatVersion);
    }

    @Nullable
    @JsonProperty(value="nestedColumnFormatVersion")
    public Integer getNestedColumnFormatVersion() {
        return this.nestedColumnFormatVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultColumnFormatConfig that = (DefaultColumnFormatConfig)o;
        return Objects.equals(this.nestedColumnFormatVersion, that.nestedColumnFormatVersion);
    }

    public int hashCode() {
        return Objects.hash(this.nestedColumnFormatVersion);
    }

    public String toString() {
        return "DefaultColumnFormatConfig{nestedColumnFormatVersion=" + this.nestedColumnFormatVersion + '}';
    }
}

