/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ConstantDimensionSelector;
import org.apache.druid.segment.ConstantMultiValueDimensionSelector;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;

public interface DimensionSelector
extends ColumnValueSelector<Object>,
DimensionDictionarySelector,
HotLoopCallee {
    public IndexedInts getRow();

    public ValueMatcher makeValueMatcher(@Nullable String var1);

    public ValueMatcher makeValueMatcher(DruidPredicateFactory var1);

    @Override
    @Deprecated
    default public float getFloat() {
        return 0.0f;
    }

    @Override
    @Deprecated
    default public double getDouble() {
        return 0.0;
    }

    @Override
    @Deprecated
    default public long getLong() {
        return 0L;
    }

    @Override
    @Deprecated
    default public boolean isNull() {
        return false;
    }

    @Nullable
    default public Object defaultGetObject() {
        return DimensionSelector.rowToObject(this.getRow(), this);
    }

    @Nullable
    public static Object rowToObject(IndexedInts row, DimensionDictionarySelector selector) {
        int rowSize = row.size();
        if (rowSize == 0) {
            return null;
        }
        if (rowSize == 1) {
            return selector.lookupName(row.get(0));
        }
        String[] strings = new String[rowSize];
        for (int i = 0; i < rowSize; ++i) {
            strings[i] = selector.lookupName(row.get(i));
        }
        return Arrays.asList(strings);
    }

    public static DimensionSelector nilSelector() {
        return NullDimensionSelectorHolder.NULL_DIMENSION_SELECTOR;
    }

    public static DimensionSelector constant(@Nullable String value) {
        if (NullHandling.isNullOrEquivalent(value)) {
            return DimensionSelector.nilSelector();
        }
        return new ConstantDimensionSelector(value);
    }

    public static DimensionSelector constant(@Nullable String value, @Nullable ExtractionFn extractionFn) {
        if (extractionFn == null) {
            return DimensionSelector.constant(value);
        }
        return DimensionSelector.constant(extractionFn.apply(value));
    }

    public static DimensionSelector multiConstant(@Nullable List<String> values) {
        if (values == null || values.isEmpty()) {
            return NullDimensionSelectorHolder.NULL_DIMENSION_SELECTOR;
        }
        if (values.size() == 1) {
            return DimensionSelector.constant(values.get(0));
        }
        return new ConstantMultiValueDimensionSelector(values);
    }

    public static DimensionSelector multiConstant(@Nullable List<String> values, @Nullable ExtractionFn extractionFn) {
        if (extractionFn == null) {
            return DimensionSelector.multiConstant(values);
        }
        if (values == null) {
            return DimensionSelector.constant(extractionFn.apply(null));
        }
        return DimensionSelector.multiConstant(values.stream().map(extractionFn::apply).collect(Collectors.toList()));
    }

    public static boolean isNilSelector(DimensionSelector selector) {
        return selector.nameLookupPossibleInAdvance() && selector.getValueCardinality() == 1 && selector.lookupName(0) == null;
    }

    public static class NullDimensionSelectorHolder {
        private static final NullDimensionSelector NULL_DIMENSION_SELECTOR = new NullDimensionSelector();

        private static class NullDimensionSelector
        implements SingleValueHistoricalDimensionSelector,
        IdLookup {
            private NullDimensionSelector() {
            }

            @Override
            public IndexedInts getRow() {
                return ZeroIndexedInts.instance();
            }

            @Override
            public int getRowValue(int offset) {
                return 0;
            }

            @Override
            public IndexedInts getRow(int offset) {
                return this.getRow();
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                if (NullHandling.isNullOrEquivalent(value)) {
                    return ValueMatchers.allTrue();
                }
                return ValueMatchers.allUnknown();
            }

            @Override
            public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                Predicate<String> predicate = predicateFactory.makeStringPredicate();
                if (predicate.apply(null)) {
                    return ValueMatchers.allTrue();
                }
                return predicateFactory.isNullInputUnknown() ? ValueMatchers.allUnknown() : ValueMatchers.allFalse();
            }

            @Override
            public int getValueCardinality() {
                return 1;
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                assert (id == 0) : "id = " + id;
                return null;
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return this;
            }

            @Override
            public int lookupId(@Nullable String name) {
                return NullHandling.isNullOrEquivalent(name) ? 0 : -1;
            }

            @Override
            @Nullable
            public Object getObject() {
                return null;
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Override
            public boolean isNull() {
                return NullHandling.sqlCompatible();
            }
        }
    }
}

