/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.RowOffsetMatcherFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BitmapOffset;
import org.apache.druid.segment.ColumnSelectorColumnIndexSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.roaringbitmap.IntIterator;

public final class FilteredOffset
extends Offset {
    private final Offset baseOffset;
    private final ValueMatcher filterMatcher;

    FilteredOffset(Offset baseOffset, ColumnSelectorFactory columnSelectorFactory, boolean descending, Filter postFilter, ColumnSelectorColumnIndexSelector bitmapIndexSelector) {
        BitmapColumnIndex columnIndex;
        this.baseOffset = baseOffset;
        CursorOffsetHolderRowOffsetMatcherFactory rowOffsetMatcherFactory = new CursorOffsetHolderRowOffsetMatcherFactory(baseOffset.getBaseReadableOffset(), descending);
        this.filterMatcher = postFilter instanceof BooleanFilter ? ((BooleanFilter)postFilter).makeMatcher(bitmapIndexSelector, columnSelectorFactory, rowOffsetMatcherFactory) : ((columnIndex = postFilter.getBitmapColumnIndex(bitmapIndexSelector)) != null && columnIndex.getIndexCapabilities().isExact() ? rowOffsetMatcherFactory.makeRowOffsetMatcher(columnIndex.computeBitmapResult(new DefaultBitmapResultFactory(bitmapIndexSelector.getBitmapFactory()), false)) : postFilter.makeMatcher(columnSelectorFactory));
        this.incrementIfNeededOnCreationOrReset();
    }

    @Override
    public void increment() {
        while (!Thread.currentThread().isInterrupted()) {
            this.baseOffset.increment();
            if (this.baseOffset.withinBounds() && !this.filterMatcher.matches(false)) continue;
            return;
        }
    }

    @Override
    public boolean withinBounds() {
        return this.baseOffset.withinBounds();
    }

    @Override
    public void reset() {
        this.baseOffset.reset();
        this.incrementIfNeededOnCreationOrReset();
    }

    private void incrementIfNeededOnCreationOrReset() {
        if (this.baseOffset.withinBounds() && !this.filterMatcher.matches(false)) {
            this.increment();
            BaseQuery.checkInterrupted();
        }
    }

    @Override
    public ReadableOffset getBaseReadableOffset() {
        return this.baseOffset.getBaseReadableOffset();
    }

    @Override
    public Offset clone() {
        throw new UnsupportedOperationException("FilteredOffset could not be cloned");
    }

    @Override
    public int getOffset() {
        return this.baseOffset.getOffset();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("baseOffset", this.baseOffset);
        inspector.visit("filterMatcher", this.filterMatcher);
    }

    private static class CursorOffsetHolderRowOffsetMatcherFactory
    implements RowOffsetMatcherFactory {
        private final ReadableOffset offset;
        private final boolean descending;

        CursorOffsetHolderRowOffsetMatcherFactory(ReadableOffset offset, boolean descending) {
            this.offset = offset;
            this.descending = descending;
        }

        @Override
        public ValueMatcher makeRowOffsetMatcher(ImmutableBitmap rowBitmap) {
            IntIterator iter;
            IntIterator intIterator = iter = this.descending ? BitmapOffset.getReverseBitmapOffsetIterator(rowBitmap) : rowBitmap.iterator();
            if (!iter.hasNext()) {
                return ValueMatchers.allFalse();
            }
            if (this.descending) {
                return new ValueMatcher(){
                    int iterOffset = Integer.MAX_VALUE;

                    @Override
                    public boolean matches(boolean includeUnknown) {
                        int currentOffset = offset.getOffset();
                        while (this.iterOffset > currentOffset && iter.hasNext()) {
                            this.iterOffset = iter.next();
                        }
                        return this.iterOffset == currentOffset;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("offset", offset);
                        inspector.visit("iter", iter);
                    }
                };
            }
            return new ValueMatcher(){
                int iterOffset = -1;

                @Override
                public boolean matches(boolean includeUnknown) {
                    int currentOffset = offset.getOffset();
                    while (this.iterOffset < currentOffset && iter.hasNext()) {
                        this.iterOffset = iter.next();
                    }
                    return this.iterOffset == currentOffset;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("offset", offset);
                    inspector.visit("iter", iter);
                }
            };
        }
    }
}

