/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.SingleScanTimeDimensionSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.column.ValueTypes;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.nested.NestedDataComplexColumn;

public class QueryableIndexColumnSelectorFactory
implements ColumnSelectorFactory,
RowIdSupplier {
    private final VirtualColumns virtualColumns;
    private final boolean descending;
    protected final ReadableOffset offset;
    private final ColumnCache columnCache;
    private final Map<DimensionSpec, DimensionSelector> dimensionSelectorCache;
    private final Map<String, ColumnValueSelector> valueSelectorCache;

    public QueryableIndexColumnSelectorFactory(VirtualColumns virtualColumns, boolean descending, ReadableOffset offset, ColumnCache columnCache) {
        this.virtualColumns = virtualColumns;
        this.descending = descending;
        this.offset = offset;
        this.columnCache = columnCache;
        this.dimensionSelectorCache = new HashMap<DimensionSpec, DimensionSelector>();
        this.valueSelectorCache = new HashMap<String, ColumnValueSelector>();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        Function<DimensionSpec, DimensionSelector> mappingFunction = spec -> {
            if (this.virtualColumns.exists(spec.getDimension())) {
                DimensionSelector dimensionSelector = this.virtualColumns.makeDimensionSelector(dimensionSpec, this.columnCache, this.offset);
                if (dimensionSelector == null) {
                    return this.virtualColumns.makeDimensionSelector(dimensionSpec, this);
                }
                return dimensionSelector;
            }
            return spec.decorate(this.makeDimensionSelectorUndecorated((DimensionSpec)spec));
        };
        DimensionSelector dimensionSelector = this.dimensionSelectorCache.get(dimensionSpec);
        if (dimensionSelector == null) {
            dimensionSelector = mappingFunction.apply(dimensionSpec);
            this.dimensionSelectorCache.put(dimensionSpec, dimensionSelector);
        }
        return dimensionSelector;
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        ColumnHolder columnHolder = this.columnCache.getColumnHolder(dimension);
        if (columnHolder == null) {
            return DimensionSelector.constant(null, extractionFn);
        }
        if (dimension.equals("__time")) {
            return new SingleScanTimeDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn, this.descending);
        }
        ColumnCapabilities capabilities = columnHolder.getCapabilities();
        if (columnHolder.getCapabilities().isNumeric()) {
            return ValueTypes.makeNumericWrappingDimensionSelector((ValueType)capabilities.getType(), this.makeColumnValueSelector(dimension), extractionFn);
        }
        BaseColumn column = this.columnCache.getColumn(dimension);
        if (column instanceof DictionaryEncodedColumn) {
            return ((DictionaryEncodedColumn)column).makeDimensionSelector(this.offset, extractionFn);
        }
        if (column instanceof NestedDataComplexColumn) {
            return ((NestedDataComplexColumn)column).makeDimensionSelector(Collections.emptyList(), this.offset, extractionFn);
        }
        return DimensionSelector.constant(null, extractionFn);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        ColumnValueSelector<Object> columnValueSelector = this.valueSelectorCache.get(columnName);
        if (columnValueSelector == null) {
            BaseColumn column;
            ColumnValueSelector<?> selector;
            columnValueSelector = this.virtualColumns.exists(columnName) ? ((selector = this.virtualColumns.makeColumnValueSelector(columnName, this.columnCache, this.offset)) == null ? this.virtualColumns.makeColumnValueSelector(columnName, this) : selector) : ((column = this.columnCache.getColumn(columnName)) != null ? column.makeColumnValueSelector(this.offset) : NilColumnValueSelector.instance());
            this.valueSelectorCache.put(columnName, columnValueSelector);
        }
        return columnValueSelector;
    }

    @Override
    @Nullable
    public RowIdSupplier getRowIdSupplier() {
        return this;
    }

    @Override
    public long getRowId() {
        return this.offset.getOffset();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(this.columnCache, columnName);
        }
        return this.columnCache.getColumnCapabilities(columnName);
    }
}

