/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.TypeDescriptor;

public enum ValueType implements TypeDescriptor
{
    DOUBLE,
    FLOAT,
    LONG,
    STRING,
    COMPLEX,
    ARRAY;


    @Override
    public boolean isNumeric() {
        return ValueType.isNumeric(this);
    }

    @Override
    public boolean isArray() {
        return ValueType.isArray(this);
    }

    @Override
    public boolean isPrimitive() {
        return this.equals(STRING) || ValueType.isNumeric(this);
    }

    @Nullable
    @JsonCreator
    public static ValueType fromString(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return ValueType.valueOf(StringUtils.toUpperCase(name));
    }

    public static boolean isNumeric(ValueType type) {
        return type == LONG || type == FLOAT || type == DOUBLE;
    }

    public static boolean isArray(ValueType type) {
        return type == ARRAY;
    }
}

