/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class IsBooleanFilter
implements Filter {
    private final Filter baseFilter;
    private final boolean isTrue;

    public IsBooleanFilter(Filter baseFilter, boolean isTrue) {
        this.baseFilter = baseFilter;
        this.isTrue = isTrue;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(final ColumnIndexSelector selector) {
        final BitmapColumnIndex baseIndex = this.baseFilter.getBitmapColumnIndex(selector);
        if (baseIndex != null && (this.isTrue || baseIndex.getIndexCapabilities().isInvertible())) {
            return new BitmapColumnIndex(){
                private final boolean useThreeValueLogic = NullHandling.useThreeValueLogic();

                @Override
                public ColumnIndexCapabilities getIndexCapabilities() {
                    return baseIndex.getIndexCapabilities();
                }

                @Override
                public double estimateSelectivity(int totalRows) {
                    return 1.0 - IsBooleanFilter.this.baseFilter.estimateSelectivity(selector);
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    if (IsBooleanFilter.this.isTrue) {
                        return baseIndex.computeBitmapResult(bitmapResultFactory, false);
                    }
                    return bitmapResultFactory.complement(baseIndex.computeBitmapResult(bitmapResultFactory, this.useThreeValueLogic), selector.getNumRows());
                }
            };
        }
        return null;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ValueMatcher baseMatcher = this.baseFilter.makeMatcher(factory);
        return new ValueMatcher(){
            private final boolean useThreeValueLogic = NullHandling.useThreeValueLogic();

            @Override
            public boolean matches(boolean includeUnknown) {
                if (IsBooleanFilter.this.isTrue) {
                    return baseMatcher.matches(false);
                }
                return !baseMatcher.matches(this.useThreeValueLogic);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseMatcher", baseMatcher);
            }
        };
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(final VectorColumnSelectorFactory factory) {
        final VectorValueMatcher baseMatcher = this.baseFilter.makeVectorMatcher(factory);
        return new BaseVectorValueMatcher(baseMatcher){
            private final VectorMatch scratch;
            private final boolean useThreeValueLogic;
            {
                super(selector);
                this.scratch = VectorMatch.wrap(new int[factory.getMaxVectorSize()]);
                this.useThreeValueLogic = NullHandling.useThreeValueLogic();
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                if (IsBooleanFilter.this.isTrue) {
                    return baseMatcher.match(mask, false);
                }
                ReadableVectorMatch baseMatch = baseMatcher.match(mask, this.useThreeValueLogic);
                this.scratch.copyFrom(mask);
                this.scratch.removeAll(baseMatch);
                assert (this.scratch.isValid(mask));
                return this.scratch;
            }
        };
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return this.baseFilter.canVectorizeMatcher(inspector);
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.baseFilter.getRequiredColumns();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return this.baseFilter.supportsRequiredColumnRewrite();
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        return new IsBooleanFilter(this.baseFilter.rewriteRequiredColumns(columnRewrites), this.isTrue);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return this.baseFilter.supportsSelectivityEstimation(columnSelector, indexSelector);
    }

    public String toString() {
        return StringUtils.format("(%s) IS %s", this.baseFilter, this.isTrue ? "TRUE" : "FALSE");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsBooleanFilter isFilter = (IsBooleanFilter)o;
        return Objects.equals(this.baseFilter, isFilter.baseFilter);
    }

    public int hashCode() {
        return Objects.hash(1, this.baseFilter, this.isTrue);
    }
}

