/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.StringConstantValueMatcherFactory;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class SelectorFilter
implements Filter {
    private final String dimension;
    private final String value;
    @Nullable
    private final FilterTuning filterTuning;

    public SelectorFilter(String dimension, String value) {
        this(dimension, value, null);
    }

    public SelectorFilter(String dimension, String value, @Nullable FilterTuning filterTuning) {
        this.dimension = dimension;
        this.value = value;
        this.filterTuning = filterTuning;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        if (!Filters.checkFilterTuningUseIndex(this.dimension, selector, this.filterTuning)) {
            return null;
        }
        boolean isNull = NullHandling.isNullOrEquivalent(this.value);
        ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(this.dimension);
        if (indexSupplier == null) {
            return Filters.makeMissingColumnNullIndex(isNull, selector);
        }
        if (isNull) {
            NullValueIndex nullValueIndex = indexSupplier.as(NullValueIndex.class);
            if (nullValueIndex == null) {
                return null;
            }
            return nullValueIndex.get();
        }
        StringValueSetIndexes valueSetIndexes = indexSupplier.as(StringValueSetIndexes.class);
        if (valueSetIndexes == null) {
            return null;
        }
        return valueSetIndexes.forValue(this.value);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return ColumnProcessors.makeProcessor(this.dimension, new StringConstantValueMatcherFactory(this.value), factory);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.dimension, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.value);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.dimension);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", columnRewrites, this.dimension);
        }
        return new SelectorFilter(rewriteDimensionTo, this.value);
    }

    public String toString() {
        return StringUtils.format("%s = %s", this.dimension, this.value);
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorFilter that = (SelectorFilter)o;
        return Objects.equals(this.getDimension(), that.getDimension()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.getDimension(), this.getValue(), this.filterTuning);
    }
}

