/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Predicate;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseNullableColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.AllFalseValueMatcher;
import org.apache.druid.segment.filter.AllTrueValueMatcher;
import org.apache.druid.segment.filter.AllUnknownValueMatcher;
import org.apache.druid.segment.filter.ConstantMatcherType;

public class ValueMatchers {
    private ValueMatchers() {
    }

    public static ValueMatcher allTrue() {
        return AllTrueValueMatcher.instance();
    }

    public static ValueMatcher allFalse() {
        return AllFalseValueMatcher.instance();
    }

    public static ValueMatcher allUnknown() {
        return AllUnknownValueMatcher.instance();
    }

    public static ValueMatcher makeStringValueMatcher(DimensionSelector selector, String value, boolean hasMultipleValues) {
        ConstantMatcherType matcherType = ValueMatchers.toConstantMatcherTypeIfPossible(selector, hasMultipleValues, (Predicate<String>)((Predicate)s -> Objects.equals(s, NullHandling.emptyToNullIfNeeded(value))));
        if (matcherType != null) {
            return matcherType.asValueMatcher();
        }
        return selector.makeValueMatcher(value);
    }

    public static ValueMatcher makeStringValueMatcher(DimensionSelector selector, DruidPredicateFactory predicateFactory, boolean hasMultipleValues) {
        Predicate<String> predicate = predicateFactory.makeStringPredicate();
        ConstantMatcherType constantMatcherType = ValueMatchers.toConstantMatcherTypeIfPossible(selector, hasMultipleValues, predicate);
        if (constantMatcherType != null) {
            return constantMatcherType.asValueMatcher();
        }
        return selector.makeValueMatcher(predicateFactory);
    }

    public static ValueMatcher makeFloatValueMatcher(BaseFloatColumnValueSelector selector, String value) {
        Float matchVal = DimensionHandlerUtils.convertObjectToFloat(value);
        if (matchVal == null) {
            return ValueMatchers.makeNumericNullValueMatcher(selector);
        }
        return ValueMatchers.makeFloatValueMatcher(selector, matchVal.floatValue());
    }

    public static ValueMatcher makeFloatValueMatcher(final BaseFloatColumnValueSelector selector, float value) {
        final int matchValIntBits = Float.floatToIntBits(value);
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                if (selector.isNull()) {
                    return includeUnknown;
                }
                return Float.floatToIntBits(selector.getFloat()) == matchValIntBits;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    public static ValueMatcher makeFloatValueMatcher(final BaseFloatColumnValueSelector selector, final DruidPredicateFactory predicateFactory) {
        final DruidFloatPredicate predicate = predicateFactory.makeFloatPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                boolean matchNull;
                boolean bl = matchNull = includeUnknown && predicateFactory.isNullInputUnknown();
                if (selector.isNull()) {
                    return matchNull || predicate.applyNull();
                }
                return predicate.applyFloat(selector.getFloat());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    public static ValueMatcher makeLongValueMatcher(BaseLongColumnValueSelector selector, String value) {
        Long matchVal = DimensionHandlerUtils.convertObjectToLong(value);
        if (matchVal == null) {
            return ValueMatchers.makeNumericNullValueMatcher(selector);
        }
        return ValueMatchers.makeLongValueMatcher(selector, matchVal);
    }

    public static ValueMatcher makeLongValueMatcher(final BaseLongColumnValueSelector selector, final long value) {
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                if (selector.isNull()) {
                    return includeUnknown;
                }
                return selector.getLong() == value;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    public static ValueMatcher makeLongValueMatcher(final BaseLongColumnValueSelector selector, final DruidPredicateFactory predicateFactory) {
        final DruidLongPredicate predicate = predicateFactory.makeLongPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                boolean matchNull;
                boolean bl = matchNull = includeUnknown && predicateFactory.isNullInputUnknown();
                if (selector.isNull()) {
                    return matchNull || predicate.applyNull();
                }
                return predicate.applyLong(selector.getLong());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    public static ValueMatcher makeDoubleValueMatcher(BaseDoubleColumnValueSelector selector, String value) {
        Double matchVal = DimensionHandlerUtils.convertObjectToDouble(value);
        if (matchVal == null) {
            return ValueMatchers.makeNumericNullValueMatcher(selector);
        }
        return ValueMatchers.makeDoubleValueMatcher(selector, matchVal);
    }

    public static ValueMatcher makeDoubleValueMatcher(final BaseDoubleColumnValueSelector selector, double value) {
        final long matchValLongBits = Double.doubleToLongBits(value);
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                if (selector.isNull()) {
                    return includeUnknown;
                }
                return Double.doubleToLongBits(selector.getDouble()) == matchValLongBits;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    public static ValueMatcher makeDoubleValueMatcher(final BaseDoubleColumnValueSelector selector, final DruidPredicateFactory predicateFactory) {
        final DruidDoublePredicate predicate = predicateFactory.makeDoublePredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                boolean matchNull;
                boolean bl = matchNull = includeUnknown && predicateFactory.isNullInputUnknown();
                if (selector.isNull()) {
                    return matchNull || predicate.applyNull();
                }
                return predicate.applyDouble(selector.getDouble());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    public static ValueMatcher makeAlwaysFalseDimensionMatcher(final DimensionSelector selector, boolean multiValue) {
        IdLookup lookup = selector.idLookup();
        if (lookup == null || !selector.nameLookupPossibleInAdvance()) {
            return new ValueMatcher(){

                @Override
                public boolean matches(boolean includeUnknown) {
                    if (includeUnknown) {
                        IndexedInts row = selector.getRow();
                        int size = row.size();
                        if (size == 0) {
                            return true;
                        }
                        for (int i = 0; i < size; ++i) {
                            if (!NullHandling.isNullOrEquivalent(selector.lookupName(row.get(i)))) continue;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("selector", selector);
                }
            };
        }
        final int nullId = lookup.lookupId(null);
        if (nullId < 0) {
            return ValueMatchers.allFalse();
        }
        if (multiValue) {
            return new ValueMatcher(){

                @Override
                public boolean matches(boolean includeUnknown) {
                    if (includeUnknown) {
                        IndexedInts row = selector.getRow();
                        int size = row.size();
                        if (size == 0) {
                            return true;
                        }
                        for (int i = 0; i < size; ++i) {
                            if (row.get(i) != nullId) continue;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("selector", selector);
                }
            };
        }
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                return includeUnknown && selector.getRow().get(0) == nullId;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    public static ValueMatcher makeAlwaysFalseNumericMatcher(final BaseNullableColumnValueSelector selector) {
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                return includeUnknown && selector.isNull();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    public static ValueMatcher makeAlwaysFalseObjectMatcher(final BaseObjectColumnValueSelector<?> selector) {
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                return includeUnknown && selector.getObject() == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Nullable
    public static ConstantMatcherType toConstantMatcherTypeIfPossible(DimensionDictionarySelector selector, boolean hasMultipleValues, Predicate<String> predicate) {
        if (selector.getValueCardinality() == 0) {
            if (predicate.apply(null)) {
                return ConstantMatcherType.ALL_TRUE;
            }
            return ConstantMatcherType.ALL_UNKNOWN;
        }
        if (!hasMultipleValues && selector.getValueCardinality() == 1 && selector.nameLookupPossibleInAdvance()) {
            String constant = selector.lookupName(0);
            if (predicate.apply((Object)constant)) {
                return ConstantMatcherType.ALL_TRUE;
            }
            if (constant == null) {
                return ConstantMatcherType.ALL_UNKNOWN;
            }
            return ConstantMatcherType.ALL_FALSE;
        }
        return null;
    }

    private static ValueMatcher makeNumericNullValueMatcher(final BaseNullableColumnValueSelector selector) {
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                return selector.isNull();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }
}

