/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.segment.index.SimpleBitmapColumnIndex;

public final class SimpleImmutableBitmapIndex
extends SimpleBitmapColumnIndex {
    private final ImmutableBitmap bitmap;

    public SimpleImmutableBitmapIndex(ImmutableBitmap bitmap) {
        this.bitmap = bitmap;
    }

    @Override
    public double estimateSelectivity(int totalRows) {
        return Math.min(1.0, (double)this.bitmap.size() / (double)totalRows);
    }

    @Override
    public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
        return bitmapResultFactory.wrapDimensionValue(this.bitmap);
    }
}

