/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.SortedMap;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.serde.Serializer;

public abstract class NestedCommonFormatColumnSerializer
implements GenericColumnSerializer<StructuredData> {
    public static final byte V0 = 0;
    public static final String STRING_DICTIONARY_FILE_NAME = "__stringDictionary";
    public static final String LONG_DICTIONARY_FILE_NAME = "__longDictionary";
    public static final String DOUBLE_DICTIONARY_FILE_NAME = "__doubleDictionary";
    public static final String ARRAY_DICTIONARY_FILE_NAME = "__arrayDictionary";
    public static final String ARRAY_ELEMENT_DICTIONARY_FILE_NAME = "__arrayElementDictionary";
    public static final String ENCODED_VALUE_COLUMN_FILE_NAME = "__encodedColumn";
    public static final String LONG_VALUE_COLUMN_FILE_NAME = "__longColumn";
    public static final String DOUBLE_VALUE_COLUMN_FILE_NAME = "__doubleColumn";
    public static final String BITMAP_INDEX_FILE_NAME = "__valueIndexes";
    public static final String ARRAY_ELEMENT_BITMAP_INDEX_FILE_NAME = "__arrayElementIndexes";
    public static final String RAW_FILE_NAME = "__raw";
    public static final String NULL_BITMAP_FILE_NAME = "__nullIndex";
    public static final String NESTED_FIELD_PREFIX = "__field_";

    public abstract void openDictionaryWriter() throws IOException;

    public void serializeFields(SortedMap<String, FieldTypeInfo.MutableTypeSet> fields) throws IOException {
    }

    public abstract void serializeDictionaries(Iterable<String> var1, Iterable<Long> var2, Iterable<Double> var3, Iterable<int[]> var4) throws IOException;

    public abstract String getColumnName();

    public abstract DictionaryIdLookup getGlobalLookup();

    public abstract boolean hasNulls();

    protected void writeInternal(FileSmoosher smoosher, Serializer serializer, String fileName) throws IOException {
        String internalName = NestedCommonFormatColumnSerializer.getInternalFileName(this.getColumnName(), fileName);
        try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(internalName, serializer.getSerializedSize());){
            serializer.writeTo(smooshChannel, smoosher);
        }
    }

    protected void writeInternal(FileSmoosher smoosher, ByteBuffer buffer, String fileName) throws IOException {
        String internalName = NestedCommonFormatColumnSerializer.getInternalFileName(this.getColumnName(), fileName);
        try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(internalName, buffer.capacity());){
            smooshChannel.write(buffer);
        }
    }

    protected void writeV0Header(WritableByteChannel channel, ByteBuffer columnNameBuffer) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{0}));
        channel.write(columnNameBuffer);
    }

    protected ByteBuffer computeFilenameBytes() {
        String columnName = this.getColumnName();
        byte[] bytes = StringUtils.toUtf8(columnName);
        int length = VByte.computeIntSize(bytes.length);
        ByteBuffer buffer = ByteBuffer.allocate(length + bytes.length).order(ByteOrder.nativeOrder());
        VByte.writeInt(buffer, bytes.length);
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }

    public static String getInternalFileName(String fileNameBase, String field) {
        return StringUtils.format("%s.%s", fileNameBase, field);
    }
}

