/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexedIntWriter;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexedWriter;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class VariantColumnSerializer
extends NestedCommonFormatColumnSerializer {
    private static final Logger log = new Logger(VariantColumnSerializer.class);
    private final String name;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final IndexSpec indexSpec;
    private final Closer closer;
    private DictionaryIdLookup dictionaryIdLookup;
    private DictionaryWriter<String> dictionaryWriter;
    private FixedIndexedWriter<Long> longDictionaryWriter;
    private FixedIndexedWriter<Double> doubleDictionaryWriter;
    private FrontCodedIntArrayIndexedWriter arrayDictionaryWriter;
    private FixedIndexedIntWriter arrayElementDictionaryWriter;
    private boolean closedForWrite = false;
    private boolean dictionarySerialized = false;
    private FixedIndexedIntWriter intermediateValueWriter;
    private ByteBuffer columnNameBytes = null;
    private boolean hasNulls;
    @Nullable
    private final Byte variantTypeSetByte;

    public VariantColumnSerializer(String name, @Nullable Byte variantTypeSetByte, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.variantTypeSetByte = variantTypeSetByte;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.closer = closer;
    }

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public DictionaryIdLookup getGlobalLookup() {
        return this.dictionaryIdLookup;
    }

    @Override
    public boolean hasNulls() {
        return this.hasNulls;
    }

    @Override
    public void openDictionaryWriter() throws IOException {
        this.dictionaryWriter = StringEncodingStrategies.getStringDictionaryWriter(this.indexSpec.getStringDictionaryEncoding(), this.segmentWriteOutMedium, this.name);
        this.dictionaryWriter.open();
        this.longDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.LONG.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.longDictionaryWriter.open();
        this.doubleDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.DOUBLE.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.doubleDictionaryWriter.open();
        this.arrayDictionaryWriter = new FrontCodedIntArrayIndexedWriter(this.segmentWriteOutMedium, ByteOrder.nativeOrder(), 4);
        this.arrayDictionaryWriter.open();
        this.arrayElementDictionaryWriter = new FixedIndexedIntWriter(this.segmentWriteOutMedium, true);
        this.arrayElementDictionaryWriter.open();
        this.dictionaryIdLookup = this.closer.register(new DictionaryIdLookup(this.name, FileUtils.getTempDir(), this.dictionaryWriter, this.longDictionaryWriter, this.doubleDictionaryWriter, this.arrayDictionaryWriter));
    }

    @Override
    public void open() throws IOException {
        if (!this.dictionarySerialized) {
            throw new IllegalStateException("Dictionary not serialized, cannot open value serializer");
        }
        this.intermediateValueWriter = new FixedIndexedIntWriter(this.segmentWriteOutMedium, false);
        this.intermediateValueWriter.open();
    }

    @Override
    public void serializeDictionaries(Iterable<String> strings, Iterable<Long> longs, Iterable<Double> doubles, Iterable<int[]> arrays) throws IOException {
        if (this.dictionarySerialized) {
            throw new ISE("Value dictionaries already serialized for column [%s], cannot serialize again", this.name);
        }
        this.dictionaryWriter.write(null);
        for (String string : strings) {
            String string2 = NullHandling.emptyToNullIfNeeded(string);
            if (string2 == null) continue;
            this.dictionaryWriter.write(string2);
        }
        for (Long l : longs) {
            if (l == null) continue;
            this.longDictionaryWriter.write(l);
        }
        for (Double d : doubles) {
            if (d == null) continue;
            this.doubleDictionaryWriter.write(d);
        }
        for (int[] nArray : arrays) {
            if (nArray == null) continue;
            this.arrayDictionaryWriter.write(nArray);
        }
        this.dictionarySerialized = true;
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        if (!this.dictionarySerialized) {
            throw new ISE("Must serialize value dictionaries before serializing values for column [%s]", this.name);
        }
        ExprEval eval = ExprEval.bestEffortOf(StructuredData.unwrap(selector.getObject()));
        if (eval.isArray()) {
            Object[] array = eval.asArray();
            int[] globalIds = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                globalIds[i] = array[i] == null ? 0 : (array[i] instanceof String ? this.dictionaryIdLookup.lookupString((String)array[i]) : (array[i] instanceof Long ? this.dictionaryIdLookup.lookupLong((Long)array[i]) : (array[i] instanceof Double ? this.dictionaryIdLookup.lookupDouble((Double)array[i]) : -1)));
                Preconditions.checkArgument((globalIds[i] >= 0 ? 1 : 0) != 0, (String)"unknown global id [%s] for value [%s]", (int)globalIds[i], (Object)array[i]);
            }
            int dictId = this.dictionaryIdLookup.lookupArray(globalIds);
            this.intermediateValueWriter.write(dictId);
            this.hasNulls = this.hasNulls || dictId == 0;
        } else {
            Object o = eval.value();
            int dictId = o == null ? 0 : (o instanceof String ? this.dictionaryIdLookup.lookupString((String)o) : (o instanceof Long ? this.dictionaryIdLookup.lookupLong((Long)o) : (o instanceof Double ? this.dictionaryIdLookup.lookupDouble((Double)o) : -1)));
            Preconditions.checkArgument((dictId >= 0 ? 1 : 0) != 0, (String)"unknown global id [%s] for value [%s]", (int)dictId, o);
            this.intermediateValueWriter.write(dictId);
            this.hasNulls = this.hasNulls || dictId == 0;
        }
    }

    private void closeForWrite() {
        if (!this.closedForWrite) {
            this.columnNameBytes = this.computeFilenameBytes();
            this.closedForWrite = true;
        }
    }

    @Override
    public long getSerializedSize() {
        this.closeForWrite();
        long size = 1 + this.columnNameBytes.capacity();
        if (this.variantTypeSetByte != null) {
            ++size;
        }
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        Preconditions.checkArgument((boolean)this.dictionaryWriter.isSorted(), (Object)"Dictionary not sorted?!?");
        String filenameBase = StringUtils.format("%s.forward_dim", this.name);
        int cardinality = this.dictionaryWriter.getCardinality() + this.longDictionaryWriter.getCardinality() + this.doubleDictionaryWriter.getCardinality() + this.arrayDictionaryWriter.getCardinality();
        CompressionStrategy compression = this.indexSpec.getDimensionCompression();
        CompressionStrategy compressionToUse = compression != CompressionStrategy.UNCOMPRESSED && compression != CompressionStrategy.NONE ? compression : CompressionStrategy.LZ4;
        CompressedVSizeColumnarIntsSerializer encodedValueSerializer = CompressedVSizeColumnarIntsSerializer.create(this.name, this.segmentWriteOutMedium, filenameBase, cardinality, compressionToUse);
        encodedValueSerializer.open();
        GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.name, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        bitmapIndexWriter.open();
        bitmapIndexWriter.setObjectsNotSorted();
        MutableBitmap[] bitmaps = new MutableBitmap[cardinality];
        Int2ObjectRBTreeMap arrayElements = new Int2ObjectRBTreeMap();
        for (int i = 0; i < bitmaps.length; ++i) {
            bitmaps[i] = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
        }
        GenericIndexedWriter<ImmutableBitmap> arrayElementIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.name + "_arrays", this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        arrayElementIndexWriter.open();
        arrayElementIndexWriter.setObjectsNotSorted();
        IntIterator rows = this.intermediateValueWriter.getIterator();
        int rowCount = 0;
        int arrayBaseId = this.dictionaryWriter.getCardinality() + this.longDictionaryWriter.getCardinality() + this.doubleDictionaryWriter.getCardinality();
        while (rows.hasNext()) {
            int dictId = rows.nextInt();
            ((SingleValueColumnarIntsSerializer)encodedValueSerializer).addValue(dictId);
            bitmaps[dictId].add(rowCount);
            if (dictId >= arrayBaseId) {
                int[] array;
                for (int elementId : array = this.arrayDictionaryWriter.get(dictId - arrayBaseId)) {
                    ((MutableBitmap)arrayElements.computeIfAbsent(elementId, id -> this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap())).add(rowCount);
                }
            }
            ++rowCount;
        }
        for (int i = 0; i < bitmaps.length; ++i) {
            MutableBitmap bitmap = bitmaps[i];
            bitmapIndexWriter.write(this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeImmutableBitmap(bitmap));
            bitmaps[i] = null;
        }
        for (Int2ObjectMap.Entry arrayElement : arrayElements.int2ObjectEntrySet()) {
            this.arrayElementDictionaryWriter.write(arrayElement.getIntKey());
            arrayElementIndexWriter.write(this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeImmutableBitmap((MutableBitmap)arrayElement.getValue()));
        }
        this.writeV0Header(channel, this.columnNameBytes);
        if (this.variantTypeSetByte != null) {
            channel.write(ByteBuffer.wrap(new byte[]{this.variantTypeSetByte}));
        }
        if (this.dictionaryIdLookup.getStringBufferMapper() != null) {
            SmooshedFileMapper fileMapper = this.dictionaryIdLookup.getStringBufferMapper();
            for (String internalName : fileMapper.getInternalFilenames()) {
                smoosher.add(internalName, fileMapper.mapFile(internalName));
            }
        } else {
            this.writeInternal(smoosher, this.dictionaryWriter, "__stringDictionary");
        }
        if (this.dictionaryIdLookup.getLongBuffer() != null) {
            this.writeInternal(smoosher, this.dictionaryIdLookup.getLongBuffer(), "__longDictionary");
        } else {
            this.writeInternal(smoosher, this.longDictionaryWriter, "__longDictionary");
        }
        if (this.dictionaryIdLookup.getDoubleBuffer() != null) {
            this.writeInternal(smoosher, this.dictionaryIdLookup.getDoubleBuffer(), "__doubleDictionary");
        } else {
            this.writeInternal(smoosher, this.doubleDictionaryWriter, "__doubleDictionary");
        }
        if (this.dictionaryIdLookup.getArrayBuffer() != null) {
            this.writeInternal(smoosher, this.dictionaryIdLookup.getArrayBuffer(), "__arrayDictionary");
        } else {
            this.writeInternal(smoosher, this.arrayDictionaryWriter, "__arrayDictionary");
        }
        this.writeInternal(smoosher, this.arrayElementDictionaryWriter, "__arrayElementDictionary");
        this.writeInternal(smoosher, encodedValueSerializer, "__encodedColumn");
        this.writeInternal(smoosher, bitmapIndexWriter, "__valueIndexes");
        this.writeInternal(smoosher, arrayElementIndexWriter, "__arrayElementIndexes");
        log.info("Column [%s] serialized successfully.", this.name);
    }
}

