/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.timeline.DataSegment;

public class SegmentStatusInCluster
implements Comparable<SegmentStatusInCluster> {
    private final boolean overshadowed;
    private final Integer replicationFactor;
    @JsonUnwrapped
    private final DataSegment dataSegment;

    @JsonCreator
    public SegmentStatusInCluster(@JsonProperty(value="overshadowed") boolean overshadowed, @JsonProperty(value="replicationFactor") @Nullable Integer replicationFactor) {
        this(null, overshadowed, replicationFactor);
    }

    public SegmentStatusInCluster(DataSegment dataSegment, boolean overshadowed, Integer replicationFactor) {
        this.dataSegment = dataSegment;
        this.overshadowed = overshadowed;
        this.replicationFactor = replicationFactor;
    }

    @JsonProperty
    public boolean isOvershadowed() {
        return this.overshadowed;
    }

    @JsonProperty
    public DataSegment getDataSegment() {
        return this.dataSegment;
    }

    @Nullable
    @JsonProperty
    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentStatusInCluster that = (SegmentStatusInCluster)o;
        return this.overshadowed == that.overshadowed && Objects.equals(this.replicationFactor, that.replicationFactor) && Objects.equals(this.dataSegment, that.dataSegment);
    }

    public int hashCode() {
        return Objects.hash(this.overshadowed, this.replicationFactor, this.dataSegment);
    }

    @Override
    public int compareTo(SegmentStatusInCluster o) {
        return this.dataSegment.getId().compareTo(o.dataSegment.getId());
    }

    public String toString() {
        return "SegmentStatusInCluster{overshadowed=" + this.overshadowed + ", replicationFactor=" + this.replicationFactor + ", dataSegment=" + this.dataSegment + '}';
    }
}

