/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.column.ValueType;

public final class Rows {
    public static List<Object> toGroupKey(long timeStamp, InputRow inputRow) {
        TreeMap<String, ImmutableSortedSet> dims = new TreeMap<String, ImmutableSortedSet>();
        for (String dim : inputRow.getDimensions()) {
            ImmutableSortedSet dimValues = ImmutableSortedSet.copyOf(inputRow.getDimension(dim));
            if (dimValues.size() <= 0) continue;
            dims.put(dim, dimValues);
        }
        return ImmutableList.of((Object)timeStamp, dims);
    }

    public static List<String> objectToStrings(Object inputValue) {
        if (inputValue == null) {
            return Collections.emptyList();
        }
        if (inputValue instanceof List) {
            return ((List)inputValue).stream().map(String::valueOf).collect(Collectors.toList());
        }
        if (inputValue instanceof byte[]) {
            return Collections.singletonList(StringUtils.encodeBase64String((byte[])inputValue));
        }
        if (inputValue instanceof Object[]) {
            return Arrays.stream((Object[])inputValue).map(String::valueOf).collect(Collectors.toList());
        }
        return Collections.singletonList(String.valueOf(inputValue));
    }

    @Nullable
    public static Number objectToNumber(String name, Object inputValue, @Nullable ValueType outputType, boolean throwParseExceptions) {
        if (outputType != null && !outputType.isNumeric()) {
            throw new IAE("Output type[%s] must be numeric", outputType);
        }
        if (inputValue == null) {
            return (Number)NullHandling.defaultValueForType(outputType != null ? outputType : ValueType.LONG);
        }
        if (inputValue instanceof Number) {
            return (Number)inputValue;
        }
        if (inputValue instanceof String) {
            try {
                String metricValueString = StringUtils.removeChar(((String)inputValue).trim(), ',');
                metricValueString = Rows.trimLeadingPlusOfLongString(metricValueString);
                Number v = null;
                if (outputType == null || outputType == ValueType.LONG) {
                    v = Longs.tryParse((String)metricValueString);
                }
                if (v == null && outputType != ValueType.LONG) {
                    v = Double.valueOf(metricValueString);
                }
                if (v == null) {
                    if (throwParseExceptions) {
                        throw new ParseException(String.valueOf(inputValue), "Unable to parse value[%s] for field[%s] as type[%s]", inputValue.getClass(), name, outputType);
                    }
                    return (Number)NullHandling.defaultValueForType(outputType);
                }
                return outputType == ValueType.FLOAT ? (Number)Float.valueOf(v.floatValue()) : (Number)v;
            }
            catch (Exception e) {
                if (throwParseExceptions) {
                    throw new ParseException(String.valueOf(inputValue), (Throwable)e, "Unable to parse value[%s] for field[%s]", inputValue, name);
                }
                return (Number)NullHandling.defaultValueForType(outputType != null ? outputType : ValueType.LONG);
            }
        }
        if (throwParseExceptions) {
            throw new ParseException(String.valueOf(inputValue), "Unknown type[%s] for field[%s]", inputValue.getClass(), name);
        }
        return (Number)NullHandling.defaultValueForType(outputType != null ? outputType : ValueType.LONG);
    }

    public static Number objectToNumber(String name, Object inputValue, boolean throwParseExceptions) {
        return Rows.objectToNumber(name, inputValue, null, throwParseExceptions);
    }

    private static String trimLeadingPlusOfLongString(String metricValueString) {
        char secondChar;
        if (metricValueString.length() > 1 && metricValueString.charAt(0) == '+' && (secondChar = metricValueString.charAt(1)) >= '0' && secondChar <= '9') {
            metricValueString = metricValueString.substring(1);
        }
        return metricValueString;
    }

    private Rows() {
    }
}

