/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.Memory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.field.NumericFieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.FloatColumnSelector;
import org.apache.druid.segment.column.ValueType;

public class FloatFieldReader
extends NumericFieldReader {
    public static FloatFieldReader forPrimitive() {
        return new FloatFieldReader(false);
    }

    public static FloatFieldReader forArray() {
        return new FloatFieldReader(true);
    }

    private FloatFieldReader(boolean forArray) {
        super(forArray);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.FLOAT;
    }

    @Override
    public ColumnValueSelector<?> getColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer, byte nullIndicatorByte) {
        return new FloatFieldSelector(memory, fieldPointer, nullIndicatorByte);
    }

    private static class FloatFieldSelector
    extends NumericFieldReader.Selector
    implements FloatColumnSelector {
        final Memory dataRegion;
        final ReadableFieldPointer fieldPointer;

        public FloatFieldSelector(Memory dataRegion, ReadableFieldPointer fieldPointer, byte nullIndicatorByte) {
            super(dataRegion, fieldPointer, nullIndicatorByte);
            this.dataRegion = dataRegion;
            this.fieldPointer = fieldPointer;
        }

        @Override
        public float getFloat() {
            assert (NullHandling.replaceWithDefault() || !this.isNull());
            int bits = this.dataRegion.getInt(this.fieldPointer.position() + 1L);
            return TransformUtils.detransformToFloat(bits);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Override
        public boolean isNull() {
            return super._isNull();
        }
    }
}

