/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.ColumnPlus;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.write.columnar.LongFrameMaker;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessorBasedColumn;
import org.apache.druid.query.rowsandcols.column.accessor.LongColumnAccessorBase;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorValueSelector;

public class LongFrameColumnReader
implements FrameColumnReader {
    private final int columnNumber;

    LongFrameColumnReader(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public Column readRACColumn(Frame frame) {
        LongFrameColumn frameCol = this.makeLongFrameColumn(frame);
        return new ColumnAccessorBasedColumn(frameCol);
    }

    @Override
    public ColumnPlus readColumn(Frame frame) {
        LongFrameColumn frameCol = this.makeLongFrameColumn(frame);
        return new ColumnPlus(frameCol, ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(frameCol.getType()).setHasNulls(NullHandling.sqlCompatible() && frameCol.hasNulls), frame.numRows());
    }

    @Nonnull
    private LongFrameColumn makeLongFrameColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory, frame.numRows());
        boolean hasNulls = LongFrameColumnReader.getHasNulls(memory);
        return new LongFrameColumn(frame, hasNulls, memory);
    }

    private void validate(Memory region, int numRows) {
        if (region.getCapacity() < 2L) {
            throw new ISE("Column is not big enough for a header", new Object[0]);
        }
        byte typeCode = region.getByte(0L);
        if (typeCode != 1) {
            throw new ISE("Column does not have the correct type code", new Object[0]);
        }
        boolean hasNulls = LongFrameColumnReader.getHasNulls(region);
        int sz = LongFrameMaker.valueSize(hasNulls);
        if (region.getCapacity() != 2L + (long)sz * (long)numRows) {
            throw new ISE("Column does not have the correct length", new Object[0]);
        }
    }

    private static boolean getHasNulls(Memory memoryRange) {
        return memoryRange.getByte(1L) != 0;
    }

    private static class LongFrameColumn
    extends LongColumnAccessorBase
    implements NumericColumn {
        private final Frame frame;
        private final boolean hasNulls;
        private final int sz;
        private final Memory memory;
        private final long memoryPosition;

        private LongFrameColumn(Frame frame, boolean hasNulls, Memory memory) {
            this.frame = frame;
            this.hasNulls = hasNulls;
            this.sz = LongFrameMaker.valueSize(hasNulls);
            this.memory = memory;
            this.memoryPosition = 2L;
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
            return new LongColumnSelector(){

                @Override
                public long getLong() {
                    assert (NullHandling.replaceWithDefault() || !this.isNull());
                    return this.getLongPhysical(frame.physicalRow(offset.getOffset()));
                }

                @Override
                public boolean isNull() {
                    return this.isNullPhysical(frame.physicalRow(offset.getOffset()));
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            };
        }

        @Override
        public VectorValueSelector makeVectorValueSelector(final ReadableVectorOffset theOffset) {
            class LongFrameColumnVectorValueSelector
            extends BaseLongVectorValueSelector {
                private final long[] longVector;
                private final boolean[] nullVector;
                private int id;

                LongFrameColumnVectorValueSelector() {
                    super(readableVectorOffset);
                    this.id = -1;
                    this.longVector = new long[this.offset.getMaxVectorSize()];
                    this.nullVector = LongFrameColumn.this.hasNulls ? new boolean[this.offset.getMaxVectorSize()] : null;
                }

                @Override
                @Nullable
                public boolean[] getNullVector() {
                    this.computeVectorsIfNeeded();
                    return this.nullVector;
                }

                @Override
                public long[] getLongVector() {
                    this.computeVectorsIfNeeded();
                    return this.longVector;
                }

                private void computeVectorsIfNeeded() {
                    if (this.id == this.offset.getId()) {
                        return;
                    }
                    if (this.offset.isContiguous()) {
                        int start = this.offset.getStartOffset();
                        for (int i = 0; i < this.offset.getCurrentVectorSize(); ++i) {
                            int physicalRow = LongFrameColumn.this.frame.physicalRow(i + start);
                            this.longVector[i] = LongFrameColumn.this.getLongPhysical(physicalRow);
                            if (!LongFrameColumn.this.hasNulls) continue;
                            this.nullVector[i] = LongFrameColumn.this.isNullPhysical(physicalRow);
                        }
                    } else {
                        int[] offsets = this.offset.getOffsets();
                        for (int i = 0; i < this.offset.getCurrentVectorSize(); ++i) {
                            int physicalRow = LongFrameColumn.this.frame.physicalRow(offsets[i]);
                            this.longVector[i] = LongFrameColumn.this.getLongPhysical(physicalRow);
                            if (!LongFrameColumn.this.hasNulls) continue;
                            this.nullVector[i] = LongFrameColumn.this.isNullPhysical(physicalRow);
                        }
                    }
                    this.id = this.offset.getId();
                }
            }
            return new LongFrameColumnVectorValueSelector();
        }

        @Override
        public int length() {
            return this.frame.numRows();
        }

        @Override
        public long getLongSingleValueRow(int rowNum) {
            if (rowNum < 0 || rowNum >= this.frame.numRows()) {
                throw new ISE("Row [%d] out of bounds", rowNum);
            }
            return this.getLongPhysical(this.frame.physicalRow(rowNum));
        }

        @Override
        public void close() {
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Override
        public int numRows() {
            return this.length();
        }

        @Override
        public boolean isNull(int rowNum) {
            return this.isNullPhysical(this.frame.physicalRow(rowNum));
        }

        @Override
        public long getLong(int rowNum) {
            return this.getLongPhysical(this.frame.physicalRow(rowNum));
        }

        private boolean isNullPhysical(int physicalRow) {
            if (this.hasNulls) {
                long rowPosition = this.memoryPosition + (long)this.sz * (long)physicalRow;
                return this.memory.getByte(rowPosition) != 0;
            }
            return false;
        }

        private long getLongPhysical(int physicalRow) {
            long rowPosition = this.memoryPosition + (long)this.sz * (long)physicalRow;
            if (this.hasNulls) {
                return this.memory.getLong(rowPosition + 1L);
            }
            return this.memory.getLong(rowPosition);
        }
    }
}

