/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.FieldReaders;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.write.InvalidNullByteException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.ComparableIntArray;
import org.apache.druid.segment.data.ComparableList;
import org.apache.druid.segment.data.ComparableStringArray;
import org.apache.druid.segment.data.IndexedInts;

public class FrameWriterUtils {
    public static final byte NULL_STRING_MARKER = -1;
    public static final byte[] NULL_STRING_MARKER_ARRAY = new byte[]{-1};
    public static final String RESERVED_FIELD_PREFIX = "___druid";

    public static long writeFrameHeader(WritableMemory memory, long startPosition, FrameType frameType, long totalSize, int numRows, int numRegions, boolean permuted) {
        long currentPosition = startPosition;
        memory.putByte(currentPosition, frameType.version());
        memory.putLong(++currentPosition, totalSize);
        memory.putInt(currentPosition += 8L, numRows);
        memory.putInt(currentPosition += 4L, numRegions);
        memory.putByte(currentPosition += 4L, permuted ? (byte)1 : 0);
        return ++currentPosition - startPosition;
    }

    public static List<ByteBuffer> getUtf8ByteBuffersFromStringSelector(DimensionSelector selector, boolean multiValue) {
        IndexedInts row = selector.getRow();
        int size = row.size();
        if (multiValue) {
            ArrayList<ByteBuffer> retVal = new ArrayList<ByteBuffer>(size);
            for (int i = 0; i < size; ++i) {
                retVal.add(FrameWriterUtils.getUtf8ByteBufferFromStringSelector(selector, row.get(i)));
            }
            return retVal;
        }
        if (size == 0) {
            return Collections.singletonList(ByteBuffer.wrap(NULL_STRING_MARKER_ARRAY));
        }
        if (size == 1) {
            return Collections.singletonList(FrameWriterUtils.getUtf8ByteBufferFromStringSelector(selector, row.get(0)));
        }
        throw new ISE("Encountered unexpected multi-value row", new Object[0]);
    }

    @Nullable
    public static List<ByteBuffer> getUtf8ByteBuffersFromStringArraySelector(BaseObjectColumnValueSelector selector) {
        Object row = selector.getObject();
        if (row == null) {
            return null;
        }
        if (row instanceof String) {
            return Collections.singletonList(FrameWriterUtils.getUtf8ByteBufferFromString((String)row));
        }
        ArrayList<ByteBuffer> retVal = new ArrayList<ByteBuffer>();
        if (row instanceof List) {
            for (int i = 0; i < ((List)row).size(); ++i) {
                retVal.add(FrameWriterUtils.getUtf8ByteBufferFromString((String)((List)row).get(i)));
            }
        } else if (row instanceof Object[]) {
            for (Object value : (Object[])row) {
                retVal.add(FrameWriterUtils.getUtf8ByteBufferFromString((String)value));
            }
        } else if (row instanceof ComparableStringArray) {
            for (String value : ((ComparableStringArray)row).getDelegate()) {
                retVal.add(FrameWriterUtils.getUtf8ByteBufferFromString(value));
            }
        } else {
            throw new ISE("Unexpected type %s found", row.getClass().getName());
        }
        return retVal;
    }

    @Nullable
    public static List<? extends Number> getNumericArrayFromObject(Object row) {
        if (row == null) {
            return null;
        }
        if (row instanceof Number) {
            return Collections.singletonList((Number)row);
        }
        ArrayList<Number> retVal = new ArrayList<Number>();
        if (row instanceof List) {
            for (int i = 0; i < ((List)row).size(); ++i) {
                retVal.add((Number)((List)row).get(i));
            }
        } else if (row instanceof Object[]) {
            for (Object value : (Object[])row) {
                retVal.add((Number)value);
            }
        } else if (row instanceof ComparableList) {
            for (Object value : ((ComparableList)row).getDelegate()) {
                retVal.add((Number)value);
            }
        } else if (row instanceof ComparableIntArray) {
            for (int value : ((ComparableIntArray)row).getDelegate()) {
                retVal.add(value);
            }
        } else {
            throw new ISE("Unexpected type %s found", row.getClass().getName());
        }
        return retVal;
    }

    public static Set<String> findDisallowedFieldNames(RowSignature signature) {
        return signature.getColumnNames().stream().filter(s -> s.startsWith(RESERVED_FIELD_PREFIX)).collect(Collectors.toSet());
    }

    public static void verifySortColumns(List<KeyColumn> keyColumns, RowSignature signature) {
        if (!FrameWriterUtils.areKeyColumnsPrefixOfSignature(keyColumns, signature)) {
            throw new IAE("Sort column [%s] must be a prefix of the signature", keyColumns.stream().map(KeyColumn::columnName).collect(Collectors.joining(", ")));
        }
        for (KeyColumn keyColumn : keyColumns) {
            ColumnType columnType = signature.getColumnType(keyColumn.columnName()).orElse(null);
            if (columnType != null && FieldReaders.create(keyColumn.columnName(), columnType).isComparable()) continue;
            throw new IAE("Sort column [%s] is not comparable (type = %s)", keyColumn.columnName(), columnType);
        }
    }

    public static void copyByteBufferToMemory(ByteBuffer src, WritableMemory dst, long dstPosition, int len, boolean allowNullBytes) {
        if (src.remaining() < len) {
            throw new ISE("Insufficient source space available", new Object[0]);
        }
        if (dst.getCapacity() - dstPosition < (long)len) {
            throw new ISE("Insufficient destination space available", new Object[0]);
        }
        int srcEnd = src.position() + len;
        long q = dstPosition;
        int p = src.position();
        while (p < srcEnd) {
            byte b = src.get(p);
            if (!allowNullBytes && b == 0) {
                ByteBuffer duplicate = src.duplicate();
                duplicate.limit(srcEnd);
                throw InvalidNullByteException.builder().value(StringUtils.fromUtf8(duplicate)).position(p - src.position()).build();
            }
            dst.putByte(q, b);
            ++p;
            ++q;
        }
    }

    private static ByteBuffer getUtf8ByteBufferFromStringSelector(DimensionDictionarySelector selector, int dictionaryId) {
        if (selector.supportsLookupNameUtf8()) {
            ByteBuffer buf = selector.lookupNameUtf8(dictionaryId);
            if (buf == null || NullHandling.replaceWithDefault() && buf.remaining() == 0) {
                return ByteBuffer.wrap(NULL_STRING_MARKER_ARRAY);
            }
            return buf;
        }
        return FrameWriterUtils.getUtf8ByteBufferFromString(selector.lookupName(dictionaryId));
    }

    private static ByteBuffer getUtf8ByteBufferFromString(@Nullable String data) {
        if (NullHandling.isNullOrEquivalent(data)) {
            return ByteBuffer.wrap(NULL_STRING_MARKER_ARRAY);
        }
        return ByteBuffer.wrap(StringUtils.toUtf8(data));
    }

    private static boolean areKeyColumnsPrefixOfSignature(List<KeyColumn> keyColumns, RowSignature signature) {
        if (keyColumns.size() > signature.size()) {
            return false;
        }
        for (int i = 0; i < keyColumns.size(); ++i) {
            if (keyColumns.get(i).columnName().equals(signature.getColumnName(i))) continue;
            return false;
        }
        return true;
    }

    public static RowSignature replaceUnknownTypesWithNestedColumns(RowSignature rowSignature) {
        RowSignature.Builder retBuilder = RowSignature.builder();
        for (int i = 0; i < rowSignature.size(); ++i) {
            String columnName = rowSignature.getColumnName(i);
            ColumnType columnType = rowSignature.getColumnType(i).orElse(ColumnType.NESTED_DATA);
            retBuilder.add(columnName, columnType);
        }
        return retBuilder.build();
    }
}

