/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;

public class Queries {
    public static List<PostAggregator> decoratePostAggregators(List<PostAggregator> postAggs, Map<String, AggregatorFactory> aggFactories) {
        ArrayList decorated = Lists.newArrayListWithExpectedSize((int)postAggs.size());
        for (PostAggregator aggregator : postAggs) {
            decorated.add(aggregator.decorate(aggFactories));
        }
        return decorated;
    }

    @Deprecated
    public static List<PostAggregator> prepareAggregations(List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        return Queries.prepareAggregations(Collections.emptyList(), aggFactories, postAggs);
    }

    public static List<PostAggregator> prepareAggregations(List<String> otherOutputNames, List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        Preconditions.checkNotNull(otherOutputNames, (Object)"otherOutputNames cannot be null");
        Preconditions.checkNotNull(aggFactories, (Object)"aggregations cannot be null");
        HashSet<String> combinedOutputNames = new HashSet<String>(otherOutputNames);
        HashMap<String, AggregatorFactory> aggsFactoryMap = new HashMap<String, AggregatorFactory>();
        for (AggregatorFactory aggFactory : aggFactories) {
            Preconditions.checkArgument((boolean)combinedOutputNames.add(aggFactory.getName()), (String)"[%s] already defined", (Object)aggFactory.getName());
            aggsFactoryMap.put(aggFactory.getName(), aggFactory);
        }
        if (postAggs != null && !postAggs.isEmpty()) {
            ArrayList decorated = Lists.newArrayListWithExpectedSize((int)postAggs.size());
            for (PostAggregator postAgg : postAggs) {
                Set<String> dependencies = postAgg.getDependentFields();
                Sets.SetView missing = Sets.difference(dependencies, combinedOutputNames);
                Preconditions.checkArgument((boolean)missing.isEmpty(), (String)"Missing fields [%s] for postAggregator [%s]", (Object)missing, (Object)postAgg.getName());
                Preconditions.checkArgument((boolean)combinedOutputNames.add(postAgg.getName()), (String)"[%s] already defined", (Object)postAgg.getName());
                decorated.add(postAgg.decorate(aggsFactoryMap));
            }
            return decorated;
        }
        return postAggs;
    }

    public static <T> Query<T> withSpecificSegments(Query<T> query, List<SegmentDescriptor> descriptors) {
        Query<T> retVal;
        if (query.getDataSource() instanceof QueryDataSource) {
            Query subQuery = ((QueryDataSource)query.getDataSource()).getQuery();
            retVal = query.withDataSource(new QueryDataSource(Queries.withSpecificSegments(subQuery, descriptors)));
        } else {
            retVal = query.withQuerySegmentSpec(new MultipleSpecificSegmentSpec(descriptors));
        }
        DataSource retDataSource = retVal.getDataSource();
        DataSourceAnalysis analysis = retDataSource.getAnalysis();
        if (!analysis.getBaseTableDataSource().isPresent()) {
            throw new ISE("Unable to apply specific segments to non-table-based dataSource[%s]", query.getDataSource());
        }
        if (analysis.getBaseQuerySegmentSpec().isPresent() && !analysis.getBaseQuerySegmentSpec().get().equals(new MultipleSpecificSegmentSpec(descriptors))) {
            throw new ISE("Unable to apply specific segments to query with dataSource[%s]", query.getDataSource());
        }
        return retVal;
    }

    public static <T> Query<T> withBaseDataSource(Query<T> query, DataSource newBaseDataSource) {
        return query.withDataSource(query.getDataSource().withUpdatedDataSource(newBaseDataSource));
    }

    public static Set<String> computeRequiredColumns(VirtualColumns virtualColumns, @Nullable DimFilter filter, List<DimensionSpec> dimensions, List<AggregatorFactory> aggregators, List<String> additionalColumns) {
        HashSet<String> requiredColumns = new HashSet<String>();
        requiredColumns.add("__time");
        for (VirtualColumn virtualColumn : virtualColumns.getVirtualColumns()) {
            for (String column : virtualColumn.requiredColumns()) {
                if (virtualColumns.exists(column)) continue;
                requiredColumns.addAll(virtualColumn.requiredColumns());
            }
        }
        if (filter != null) {
            for (String column : filter.getRequiredColumns()) {
                if (virtualColumns.exists(column)) continue;
                requiredColumns.add(column);
            }
        }
        for (DimensionSpec dimensionSpec : dimensions) {
            if (virtualColumns.exists(dimensionSpec.getDimension())) continue;
            requiredColumns.add(dimensionSpec.getDimension());
        }
        for (AggregatorFactory aggregator : aggregators) {
            for (String column : aggregator.requiredFields()) {
                if (virtualColumns.exists(column)) continue;
                requiredColumns.add(column);
            }
        }
        for (String column : additionalColumns) {
            if (virtualColumns.exists(column)) continue;
            requiredColumns.add(column);
        }
        return requiredColumns;
    }

    public static <T> Query<T> withMaxScatterGatherBytes(Query<T> query, long maxScatterGatherBytesLimit) {
        QueryContext context = query.context();
        if (!context.containsKey("maxScatterGatherBytes")) {
            return query.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"maxScatterGatherBytes", (Object)maxScatterGatherBytesLimit));
        }
        context.verifyMaxScatterGatherBytes(maxScatterGatherBytesLimit);
        return query;
    }

    public static <T> Query<T> withTimeout(Query<T> query, long timeout) {
        return query.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"timeout", (Object)timeout));
    }

    public static <T> Query<T> withDefaultTimeout(Query<T> query, long defaultTimeout) {
        return query.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"defaultTimeout", (Object)defaultTimeout));
    }
}

