/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import com.google.common.primitives.Longs;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.segment.ColumnValueSelector;

public class GenericFirstAggregateCombiner<T extends SerializablePair<Long, ?>>
extends ObjectAggregateCombiner<T> {
    private T firstValue;
    private final Class<T> pairClass;

    public GenericFirstAggregateCombiner(Class<T> pairClass) {
        this.pairClass = pairClass;
    }

    @Override
    public void reset(ColumnValueSelector selector) {
        this.firstValue = (SerializablePair)selector.getObject();
    }

    @Override
    public void fold(ColumnValueSelector selector) {
        SerializablePair newValue = (SerializablePair)selector.getObject();
        if (Longs.compare((long)((Long)((SerializablePair)this.firstValue).lhs), (long)((Long)newValue.lhs)) > 0) {
            this.firstValue = newValue;
        }
    }

    @Override
    @Nullable
    public T getObject() {
        return this.firstValue;
    }

    @Override
    public Class<T> classOfObject() {
        return this.pairClass;
    }
}

