/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.first.NumericFirstBufferAggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;

public class LongFirstBufferAggregator
extends NumericFirstBufferAggregator {
    public LongFirstBufferAggregator(BaseLongColumnValueSelector timeSelector, ColumnValueSelector valueSelector, boolean needsFoldCheck) {
        super(timeSelector, valueSelector, needsFoldCheck);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putLong(position, 0L);
    }

    @Override
    void putValue(ByteBuffer buf, int position, ColumnValueSelector valueSelector) {
        buf.putLong(position, valueSelector.getLong());
    }

    @Override
    void putValue(ByteBuffer buf, int position, Number value) {
        buf.putLong(position, value.longValue());
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePairLongLong(buf.getLong(position), rhsNull ? null : Long.valueOf(buf.getLong(position + 9)));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return buf.getLong(position + 9);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return buf.getLong(position + 9);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getLong(position + 9);
    }
}

