/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;

public abstract class NumericFirstBufferAggregator
implements BufferAggregator {
    static final int NULL_OFFSET = 8;
    static final int VALUE_OFFSET = 9;
    private final boolean useDefault = NullHandling.replaceWithDefault();
    private final BaseLongColumnValueSelector timeSelector;
    private final boolean needsFoldCheck;
    final ColumnValueSelector valueSelector;

    public NumericFirstBufferAggregator(BaseLongColumnValueSelector timeSelector, ColumnValueSelector valueSelector, boolean needsFoldCheck) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.needsFoldCheck = needsFoldCheck;
    }

    abstract void initValue(ByteBuffer var1, int var2);

    abstract void putValue(ByteBuffer var1, int var2, ColumnValueSelector var3);

    abstract void putValue(ByteBuffer var1, int var2, Number var3);

    void updateTimeWithValue(ByteBuffer buf, int position, long time, ColumnValueSelector valueSelector) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)0);
        this.putValue(buf, position + 9, valueSelector);
    }

    void updateTimeWithValue(ByteBuffer buf, int position, long time, Number value) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)0);
        this.putValue(buf, position + 9, value);
    }

    void updateTimeWithNull(ByteBuffer buf, int position, long time) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)1);
    }

    boolean isValueNull(ByteBuffer buf, int position) {
        return buf.get(position + 8) == 1;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MAX_VALUE);
        buf.put(position + 8, this.useDefault ? (byte)0 : 1);
        this.initValue(buf, position + 9);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        Object object;
        if (this.timeSelector.isNull()) {
            return;
        }
        long firstTime = buf.getLong(position);
        if (this.needsFoldCheck && (object = this.valueSelector.getObject()) instanceof SerializablePair) {
            SerializablePair inPair = (SerializablePair)object;
            if ((Long)inPair.lhs < firstTime) {
                if (inPair.rhs == null) {
                    this.updateTimeWithNull(buf, position, (Long)inPair.lhs);
                } else {
                    this.updateTimeWithValue(buf, position, (long)((Long)inPair.lhs), (Number)inPair.rhs);
                }
            }
            return;
        }
        long time = this.timeSelector.getLong();
        if (time < firstTime) {
            if (this.useDefault || !this.valueSelector.isNull()) {
                this.updateTimeWithValue(buf, position, time, this.valueSelector);
            } else {
                this.updateTimeWithNull(buf, position, time);
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("timeSelector", this.timeSelector);
        inspector.visit("valueSelector", this.valueSelector);
    }
}

