/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.SerializablePairLongDouble;
import org.apache.druid.query.aggregation.last.NumericLastBufferAggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;

public class DoubleLastBufferAggregator
extends NumericLastBufferAggregator {
    public DoubleLastBufferAggregator(BaseLongColumnValueSelector timeSelector, ColumnValueSelector valueSelector, boolean needsFoldCheck) {
        super(timeSelector, valueSelector, needsFoldCheck);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putDouble(position, 0.0);
    }

    @Override
    void putValue(ByteBuffer buf, int position, ColumnValueSelector valueSelector) {
        buf.putDouble(position, valueSelector.getDouble());
    }

    @Override
    void putValue(ByteBuffer buf, int position, Number value) {
        buf.putDouble(position, value.doubleValue());
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePairLongDouble(buf.getLong(position), rhsNull ? null : Double.valueOf(buf.getDouble(position + 9)));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return (float)buf.getDouble(position + 9);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getDouble(position + 9);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getDouble(position + 9);
    }
}

