/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import org.apache.druid.collections.SerializablePair;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;

public abstract class NumericLastAggregator
implements Aggregator {
    private final boolean useDefault = NullHandling.replaceWithDefault();
    private final BaseLongColumnValueSelector timeSelector;
    final ColumnValueSelector valueSelector;
    final boolean needsFoldCheck;
    long lastTime;
    boolean rhsNull;

    public NumericLastAggregator(BaseLongColumnValueSelector timeSelector, ColumnValueSelector valueSelector, boolean needsFoldCheck) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.needsFoldCheck = needsFoldCheck;
        this.lastTime = Long.MIN_VALUE;
        this.rhsNull = !this.useDefault;
    }

    abstract void setLastValue();

    abstract void setLastValue(Number var1);

    @Override
    public void aggregate() {
        Object object;
        if (this.timeSelector.isNull()) {
            return;
        }
        if (this.needsFoldCheck && (object = this.valueSelector.getObject()) instanceof SerializablePair) {
            SerializablePair inPair = (SerializablePair)object;
            if ((Long)inPair.lhs >= this.lastTime) {
                this.lastTime = (Long)inPair.lhs;
                if (inPair.rhs == null) {
                    this.rhsNull = true;
                } else {
                    this.rhsNull = false;
                    this.setLastValue((Number)inPair.rhs);
                }
            }
            return;
        }
        long time = this.timeSelector.getLong();
        if (time >= this.lastTime) {
            this.lastTime = time;
            if (this.useDefault || !this.valueSelector.isNull()) {
                this.setLastValue();
                this.rhsNull = false;
            } else {
                this.setLastValue(0);
                this.rhsNull = true;
            }
        }
    }

    @Override
    public void close() {
    }
}

