/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public abstract class NumericLastVectorAggregator
implements VectorAggregator {
    static final int NULL_OFFSET = 8;
    static final int VALUE_OFFSET = 9;
    final VectorValueSelector valueSelector;
    final VectorObjectSelector objectSelector;
    private final boolean useDefault = NullHandling.replaceWithDefault();
    private final VectorValueSelector timeSelector;
    private long lastTime;

    NumericLastVectorAggregator(VectorValueSelector timeSelector, VectorValueSelector valueSelector, VectorObjectSelector objectSelector) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.objectSelector = objectSelector;
        this.lastTime = Long.MIN_VALUE;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MIN_VALUE);
        buf.put(position + 8, this.useDefault ? (byte)0 : 1);
        this.initValue(buf, position + 9);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        if (this.timeSelector == null) {
            return;
        }
        long[] timeVector = this.timeSelector.getLongVector();
        Object[] objectsWhichMightBeNumeric = null;
        boolean[] nullValueVector = null;
        boolean nullAbsent = false;
        if (this.objectSelector != null) {
            objectsWhichMightBeNumeric = this.objectSelector.getObjectVector();
        } else if (this.valueSelector != null) {
            nullValueVector = this.valueSelector.getNullVector();
        }
        this.lastTime = buf.getLong(position);
        if (nullValueVector == null) {
            nullAbsent = true;
        }
        int index = endRow - 1;
        if (!this.useDefault && !nullAbsent) {
            for (int i = endRow - 1; i >= startRow; --i) {
                if (nullValueVector[i]) continue;
                index = i;
                break;
            }
        }
        if (objectsWhichMightBeNumeric != null) {
            SerializablePair inPair = (SerializablePair)objectsWhichMightBeNumeric[index];
            if (inPair.lhs != null && (Long)inPair.lhs >= this.lastTime) {
                this.lastTime = (Long)inPair.lhs;
                if (this.useDefault || inPair.rhs != null) {
                    this.updateTimeWithValue(buf, position, this.lastTime, index);
                } else {
                    this.updateTimeWithNull(buf, position, this.lastTime);
                }
            }
        } else {
            long latestTime = timeVector[index];
            if (latestTime >= this.lastTime) {
                this.lastTime = latestTime;
                if (this.useDefault || nullValueVector == null || !nullValueVector[index]) {
                    this.updateTimeWithValue(buf, position, this.lastTime, index);
                } else {
                    this.updateTimeWithNull(buf, position, this.lastTime);
                }
            }
        }
    }

    boolean isValueNull(ByteBuffer buf, int position) {
        return buf.get(position + 8) == 1;
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        if (this.timeSelector == null) {
            return;
        }
        long[] timeVector = this.timeSelector.getLongVector();
        Object[] objectsWhichMightBeNumeric = null;
        boolean[] nulls = null;
        if (this.objectSelector != null) {
            objectsWhichMightBeNumeric = this.objectSelector.getObjectVector();
        } else if (this.valueSelector != null) {
            nulls = this.useDefault ? null : this.valueSelector.getNullVector();
        }
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            int row = rows == null ? i : rows[i];
            long lastTime = buf.getLong(position);
            if (objectsWhichMightBeNumeric != null) {
                SerializablePair inPair = (SerializablePair)objectsWhichMightBeNumeric[row];
                if (!this.useDefault && inPair == null || inPair.lhs == null || (Long)inPair.lhs < lastTime) continue;
                if (inPair.rhs != null) {
                    this.updateTimeWithValue(buf, position, (Long)inPair.lhs, row);
                    continue;
                }
                this.updateTimeWithNull(buf, position, (Long)inPair.lhs);
                continue;
            }
            if (timeVector[row] < lastTime) continue;
            if (this.useDefault || nulls == null || !nulls[row]) {
                this.updateTimeWithValue(buf, position, timeVector[row], row);
                continue;
            }
            this.updateTimeWithNull(buf, position, timeVector[row]);
        }
    }

    void updateTimeWithValue(ByteBuffer buf, int position, long time, int index) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)0);
        this.putValue(buf, position + 9, index);
    }

    void updateTimeWithNull(ByteBuffer buf, int position, long time) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)1);
    }

    abstract void initValue(ByteBuffer var1, int var2);

    abstract void putValue(ByteBuffer var1, int var2, int var3);

    @Override
    public void close() {
    }
}

