/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;

public class GroupByQueryResources
implements Closeable {
    private static final Logger log = new Logger(GroupByQueryResources.class);
    private static final int MAX_MERGE_BUFFER_NUM_WITHOUT_SUBTOTAL = 2;
    @Nullable
    private final List<ReferenceCountingResourceHolder<ByteBuffer>> mergeBufferHolders;
    private final Deque<ByteBuffer> mergeBuffers;

    private static int countRequiredMergeBufferNumWithoutSubtotal(Query query, int foundNum) {
        DataSource dataSource = query.getDataSource();
        if (foundNum == 3 || !(dataSource instanceof QueryDataSource)) {
            return foundNum - 1;
        }
        return GroupByQueryResources.countRequiredMergeBufferNumWithoutSubtotal(((QueryDataSource)dataSource).getQuery(), foundNum + 1);
    }

    private static int numMergeBuffersNeededForSubtotalsSpec(GroupByQuery query) {
        Query subQuery;
        List<List<String>> subtotalSpecs = query.getSubtotalsSpec();
        DataSource dataSource = query.getDataSource();
        int numMergeBuffersNeededForSubQuerySubtotal = 0;
        if (dataSource instanceof QueryDataSource && (subQuery = ((QueryDataSource)dataSource).getQuery()) instanceof GroupByQuery) {
            numMergeBuffersNeededForSubQuerySubtotal = GroupByQueryResources.numMergeBuffersNeededForSubtotalsSpec((GroupByQuery)subQuery);
        }
        if (subtotalSpecs == null || subtotalSpecs.size() == 0) {
            return numMergeBuffersNeededForSubQuerySubtotal;
        }
        List queryDimOutputNames = query.getDimensions().stream().map(DimensionSpec::getOutputName).collect(Collectors.toList());
        for (List<String> subtotalSpec : subtotalSpecs) {
            if (Utils.isPrefix(subtotalSpec, queryDimOutputNames)) continue;
            return 2;
        }
        return Math.max(1, numMergeBuffersNeededForSubQuerySubtotal);
    }

    @VisibleForTesting
    public static int countRequiredMergeBufferNum(GroupByQuery query) {
        return GroupByQueryResources.countRequiredMergeBufferNumWithoutSubtotal(query, 1) + GroupByQueryResources.numMergeBuffersNeededForSubtotalsSpec(query);
    }

    public GroupByQueryResources() {
        this.mergeBufferHolders = null;
        this.mergeBuffers = new ArrayDeque<ByteBuffer>();
    }

    public GroupByQueryResources(List<ReferenceCountingResourceHolder<ByteBuffer>> mergeBufferHolders) {
        this.mergeBufferHolders = mergeBufferHolders;
        this.mergeBuffers = new ArrayDeque<ByteBuffer>(mergeBufferHolders.size());
        mergeBufferHolders.forEach(holder -> this.mergeBuffers.add((ByteBuffer)holder.get()));
    }

    public ResourceHolder<ByteBuffer> getMergeBuffer() {
        final ByteBuffer buffer = this.mergeBuffers.pop();
        return new ResourceHolder<ByteBuffer>(){

            @Override
            public ByteBuffer get() {
                return buffer;
            }

            @Override
            public void close() {
                GroupByQueryResources.this.mergeBuffers.add(buffer);
            }
        };
    }

    @Override
    public void close() {
        if (this.mergeBufferHolders != null) {
            if (this.mergeBuffers.size() != this.mergeBufferHolders.size()) {
                log.warn("%d resources are not returned yet", this.mergeBufferHolders.size() - this.mergeBuffers.size());
            }
            this.mergeBufferHolders.forEach(ReferenceCountingResourceHolder::close);
        }
    }
}

