/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public class ComparableIntArray
implements Comparable<ComparableIntArray> {
    public static final ComparableIntArray EMPTY_ARRAY = new ComparableIntArray(new int[0]);
    final int[] delegate;
    private int hashCode;
    private boolean hashCodeComputed;

    private ComparableIntArray(int[] array) {
        this.delegate = array;
    }

    @JsonCreator
    public static ComparableIntArray of(int ... array) {
        if (array.length == 0) {
            return EMPTY_ARRAY;
        }
        return new ComparableIntArray(array);
    }

    @JsonValue
    public int[] getDelegate() {
        return this.delegate;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = Arrays.hashCode(this.delegate);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals(this.delegate, ((ComparableIntArray)obj).getDelegate());
    }

    @Override
    public int compareTo(ComparableIntArray rhs) {
        if (rhs == null) {
            return 1;
        }
        int minSize = Math.min(this.getDelegate().length, rhs.getDelegate().length);
        if (this.delegate == rhs.getDelegate()) {
            return 0;
        }
        for (int i = 0; i < minSize; ++i) {
            int cmp = Integer.compare(this.delegate[i], rhs.getDelegate()[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (this.getDelegate().length == rhs.getDelegate().length) {
            return 0;
        }
        if (this.getDelegate().length < rhs.getDelegate().length) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return Arrays.toString(this.delegate);
    }
}

