/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.SimpleColumnIndexCapabilities;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.incremental.SpatialDimensionRowTransformer;
import org.apache.druid.segment.index.AllUnknownBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.SpatialIndex;

public class SpatialFilter
implements Filter {
    private final String dimension;
    private final Bound bound;
    private final FilterTuning filterTuning;

    public SpatialFilter(String dimension, Bound bound, FilterTuning filterTuning) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        this.bound = (Bound)Preconditions.checkNotNull((Object)bound, (Object)"bound");
        this.filterTuning = filterTuning;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        if (!Filters.checkFilterTuningUseIndex(this.dimension, selector, this.filterTuning)) {
            return null;
        }
        ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(this.dimension);
        if (indexSupplier == null) {
            return new AllUnknownBitmapColumnIndex(selector);
        }
        final SpatialIndex spatialIndex = indexSupplier.as(SpatialIndex.class);
        if (spatialIndex == null) {
            return null;
        }
        return new BitmapColumnIndex(){

            @Override
            public ColumnIndexCapabilities getIndexCapabilities() {
                return new SimpleColumnIndexCapabilities(true, true);
            }

            @Override
            public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                Iterable<ImmutableBitmap> search = spatialIndex.getRTree().search(SpatialFilter.this.bound);
                return bitmapResultFactory.unionDimensionValueBitmaps(search);
            }
        };
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, new BoundDruidPredicateFactory(this.bound));
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpatialFilter that = (SpatialFilter)o;
        return Objects.equals(this.dimension, that.dimension) && Objects.equals(this.bound, that.bound) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.bound, this.filterTuning);
    }

    @VisibleForTesting
    static class BoundDruidPredicateFactory
    implements DruidPredicateFactory {
        private final Bound bound;

        BoundDruidPredicateFactory(Bound bound) {
            this.bound = bound;
        }

        @Override
        public DruidObjectPredicate<String> makeStringPredicate() {
            return input -> {
                if (input == null) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                float[] coordinate = SpatialDimensionRowTransformer.decode(input);
                return DruidPredicateMatch.of(this.bound.contains(coordinate));
            };
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            return DruidLongPredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            return DruidFloatPredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            return DruidDoublePredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundDruidPredicateFactory that = (BoundDruidPredicateFactory)o;
            return Objects.equals(this.bound, that.bound);
        }

        public int hashCode() {
            return Objects.hash(this.bound);
        }
    }
}

