/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.StorageConnector;

public class LocalFileStorageConnector
implements StorageConnector {
    private static final Logger log = new Logger(LocalFileStorageConnector.class);
    private final File basePath;

    public LocalFileStorageConnector(File basePath) throws IOException {
        this.basePath = basePath;
        FileUtils.mkdirp(basePath);
    }

    @Override
    public boolean pathExists(String path) {
        return this.fileWithBasePath(path).exists();
    }

    @Override
    public InputStream read(String path) throws IOException {
        return Files.newInputStream(this.fileWithBasePath(path).toPath(), new OpenOption[0]);
    }

    @Override
    public InputStream readRange(String path, long from, long size) throws IOException {
        if (!this.pathExists(path)) {
            throw new FileNotFoundException("Unable to find file " + this.fileWithBasePath(path).toPath() + " for reading");
        }
        long length = this.fileWithBasePath(path).length();
        if (from < 0L || size < 0L || from + size > length) {
            throw new IAE("Invalid arguments for reading %s. from = %d, readSize = %d, fileSize = %d", this.fileWithBasePath(path).toPath(), from, size, length);
        }
        FileChannel fileChannel = FileChannel.open(this.fileWithBasePath(path).toPath(), StandardOpenOption.READ);
        return new BoundedInputStream(Channels.newInputStream(fileChannel.position(from)), size);
    }

    @Override
    public OutputStream write(String path) throws IOException {
        File toWrite = this.fileWithBasePath(path);
        FileUtils.mkdirp(toWrite.getParentFile());
        return Files.newOutputStream(toWrite.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    @Override
    public void deleteFile(String path) throws IOException {
        log.debug("Deleting file at path: [%s]", path);
        File toDelete = this.fileWithBasePath(path);
        if (toDelete.isDirectory()) {
            throw new IAE(StringUtils.format("Found a directory on path[%s]. Please use deleteRecursively to delete dirs", path), new Object[0]);
        }
        Files.delete(this.fileWithBasePath(path).toPath());
    }

    @Override
    public void deleteFiles(Iterable<String> paths) throws IOException {
        for (String path : paths) {
            log.debug("Deleting file at path: [%s]", path);
            this.deleteFile(path);
        }
    }

    @Override
    public void deleteRecursively(String dirName) throws IOException {
        log.debug("Deleting directory at path: [%s]", dirName);
        FileUtils.deleteDirectory(this.fileWithBasePath(dirName));
    }

    @Override
    public Iterator<String> listDir(String dirName) {
        File directory = this.fileWithBasePath(dirName);
        if (!directory.exists()) {
            throw new IAE("No directory exists on path [%s]", dirName);
        }
        if (!directory.isDirectory()) {
            throw new IAE("Cannot list contents of [%s] since it is not a directory", dirName);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new ISE("Unable to fetch the file list from the path [%s]", dirName);
        }
        return Arrays.stream(files).map(File::getName).iterator();
    }

    public File getBasePath() {
        return this.basePath;
    }

    private File fileWithBasePath(String path) {
        return new File(this.basePath, path);
    }
}

