/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class EitherTest {
    @Test
    public void testValueString() {
        Either either = Either.value((Object)"yay");
        Assert.assertFalse((boolean)either.isError());
        Assert.assertTrue((boolean)either.isValue());
        Assert.assertEquals((Object)"yay", (Object)either.valueOrThrow());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Either)either).error());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Not an error"));
        Assert.assertEquals((Object)"Value[yay]", (Object)either.toString());
        Assert.assertEquals((Object)Either.value((Object)"YAY"), (Object)either.map(StringUtils::toUpperCase));
    }

    @Test
    public void testValueNull() {
        Either either = Either.value(null);
        Assert.assertFalse((boolean)either.isError());
        Assert.assertTrue((boolean)either.isValue());
        Assert.assertNull((Object)either.valueOrThrow());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Either)either).error());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Not an error"));
        Assert.assertEquals((Object)"Value[null]", (Object)either.toString());
        Assert.assertEquals((Object)Either.value((Object)"nullxyz"), (Object)either.map(s -> s + "xyz"));
    }

    @Test
    public void testErrorString() {
        Either either = Either.error((Object)"oh no");
        Assert.assertTrue((boolean)either.isError());
        Assert.assertFalse((boolean)either.isValue());
        Assert.assertEquals((Object)"oh no", (Object)either.error());
        RuntimeException e = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> ((Either)either).valueOrThrow());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"oh no"));
        Assert.assertEquals((Object)"Error[oh no]", (Object)either.toString());
        Assert.assertEquals((Object)either, (Object)either.map(o -> "this does nothing because the Either is an error"));
    }

    @Test
    public void testErrorThrowable() {
        Either either = Either.error((Object)new AssertionError((Object)"oh no"));
        Assert.assertTrue((boolean)either.isError());
        Assert.assertFalse((boolean)either.isValue());
        MatcherAssert.assertThat((Object)((Throwable)either.error()), (Matcher)CoreMatchers.instanceOf(AssertionError.class));
        MatcherAssert.assertThat((Object)((Throwable)either.error()).getMessage(), (Matcher)CoreMatchers.equalTo((Object)"oh no"));
        RuntimeException e = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> ((Either)either).valueOrThrow());
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(AssertionError.class));
        MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.equalTo((Object)"oh no"));
        Assert.assertEquals((Object)"Error[java.lang.AssertionError: oh no]", (Object)either.toString());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(Either.class).usingGetClass().verify();
    }
}

