/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.MaxSizeSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.CombiningInputSource;
import org.apache.druid.data.input.impl.NoopInputFormat;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Pair;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class CombiningInputSourceTest {
    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new SimpleModule("test-module").registerSubtypes(new Class[]{TestFileInputSource.class, TestUriInputSource.class}));
        TestFileInputSource fileSource = new TestFileInputSource((List)ImmutableList.of((Object)new File("myFile").getAbsoluteFile()));
        TestUriInputSource uriInputSource = new TestUriInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test")));
        CombiningInputSource combiningInputSource = new CombiningInputSource((List)ImmutableList.of((Object)((Object)fileSource), (Object)((Object)uriInputSource)));
        byte[] json = mapper.writeValueAsBytes((Object)combiningInputSource);
        CombiningInputSource fromJson = (CombiningInputSource)mapper.readValue(json, InputSource.class);
        Assert.assertEquals((Object)combiningInputSource, (Object)fromJson);
    }

    @Test
    public void testGetTypes() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new SimpleModule("test-module").registerSubtypes(new Class[]{TestFileInputSource.class, TestUriInputSource.class}));
        TestFileInputSource fileSource = new TestFileInputSource((List)ImmutableList.of((Object)new File("myFile").getAbsoluteFile()));
        TestUriInputSource uriInputSource = new TestUriInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test")));
        CombiningInputSource combiningInputSource = new CombiningInputSource((List)ImmutableList.of((Object)((Object)fileSource), (Object)((Object)uriInputSource)));
        HashSet<String> expectedTypes = new HashSet<String>();
        expectedTypes.addAll(fileSource.getTypes());
        expectedTypes.addAll(uriInputSource.getTypes());
        Assert.assertEquals(expectedTypes, (Object)combiningInputSource.getTypes());
    }

    @Test
    public void testEstimateNumSplits() {
        File file = (File)EasyMock.niceMock(File.class);
        EasyMock.expect((Object)file.length()).andReturn((Object)5L).anyTimes();
        EasyMock.replay((Object[])new Object[]{file});
        TestFileInputSource fileSource = new TestFileInputSource(CombiningInputSourceTest.generateFiles(3));
        TestUriInputSource uriInputSource = new TestUriInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test1"), (Object)URI.create("http://test.com/http-test2"), (Object)URI.create("http://test.com/http-test3")));
        CombiningInputSource combiningInputSource = new CombiningInputSource((List)ImmutableList.of((Object)((Object)fileSource), (Object)((Object)uriInputSource)));
        Assert.assertEquals((long)combiningInputSource.estimateNumSplits((InputFormat)new NoopInputFormat(), (SplitHintSpec)new MaxSizeSplitHintSpec(new HumanReadableBytes(5L), null)), (long)6L);
    }

    @Test
    public void testCreateSplits() {
        InputSplit fileSplits;
        Pair splitPair;
        int i;
        File file = (File)EasyMock.niceMock(File.class);
        EasyMock.expect((Object)file.length()).andReturn((Object)30L).anyTimes();
        EasyMock.replay((Object[])new Object[]{file});
        TestFileInputSource fileSource = new TestFileInputSource(CombiningInputSourceTest.generateFiles(3));
        TestUriInputSource uriInputSource = new TestUriInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test3"), (Object)URI.create("http://test.com/http-test4"), (Object)URI.create("http://test.com/http-test5")));
        CombiningInputSource combiningInputSource = new CombiningInputSource((List)ImmutableList.of((Object)((Object)fileSource), (Object)((Object)uriInputSource)));
        List combinedInputSplits = combiningInputSource.createSplits((InputFormat)new NoopInputFormat(), (SplitHintSpec)new MaxSizeSplitHintSpec(new HumanReadableBytes(5L), null)).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)combinedInputSplits.size());
        for (i = 0; i < 3; ++i) {
            splitPair = (Pair)((InputSplit)combinedInputSplits.get(i)).get();
            fileSplits = (InputSplit)splitPair.rhs;
            Assert.assertTrue((boolean)(splitPair.lhs instanceof TestFileInputSource));
            Assert.assertEquals((long)5L, (long)((File)fileSplits.get()).length());
        }
        for (i = 3; i < combinedInputSplits.size(); ++i) {
            splitPair = (Pair)((InputSplit)combinedInputSplits.get(i)).get();
            fileSplits = (InputSplit)splitPair.rhs;
            Assert.assertTrue((boolean)(splitPair.lhs instanceof TestUriInputSource));
            Assert.assertEquals((Object)URI.create("http://test.com/http-test" + i), (Object)fileSplits.get());
        }
    }

    @Test
    public void testWithSplits() {
        TestUriInputSource uriInputSource = new TestUriInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test1")));
        CombiningInputSource combiningInputSource = new CombiningInputSource((List)ImmutableList.of((Object)((Object)uriInputSource)));
        InputSplit testUriSplit = new InputSplit((Object)URI.create("http://test.com/http-test1"));
        TestUriInputSource urlInputSourceWithSplit = (TestUriInputSource)combiningInputSource.withSplit(new InputSplit((Object)Pair.of((Object)((Object)uriInputSource), (Object)testUriSplit)));
        Assert.assertEquals((Object)((Object)uriInputSource), (Object)((Object)urlInputSourceWithSplit));
    }

    @Test
    public void testNeedsFormat() {
        TestUriInputSource uriInputSource = new TestUriInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test1")));
        TestFileInputSource fileSource = new TestFileInputSource(CombiningInputSourceTest.generateFiles(3));
        CombiningInputSource combiningInputSource = new CombiningInputSource((List)ImmutableList.of((Object)((Object)uriInputSource), (Object)((Object)fileSource)));
        Assert.assertTrue((boolean)combiningInputSource.needsFormat());
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(CombiningInputSource.class).withNonnullFields(new String[]{"delegates"}).usingGetClass().verify();
    }

    private static List<File> generateFiles(int numFiles) {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < numFiles; ++i) {
            File file = (File)EasyMock.niceMock(File.class);
            EasyMock.expect((Object)file.length()).andReturn((Object)5L).anyTimes();
            EasyMock.replay((Object[])new Object[]{file});
            files.add(file);
        }
        return files;
    }

    private static class TestUriInputSource
    extends AbstractInputSource
    implements SplittableInputSource<URI> {
        private final List<URI> uris;

        @JsonCreator
        private TestUriInputSource(@JsonProperty(value="uris") List<URI> uriList) {
            this.uris = uriList;
        }

        @JsonIgnore
        public Set<String> getTypes() {
            return Collections.singleton("testUri");
        }

        @JsonProperty
        public List<URI> getUris() {
            return this.uris;
        }

        public Stream<InputSplit<URI>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return this.uris.stream().map(InputSplit::new);
        }

        public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return this.uris.size();
        }

        public SplittableInputSource<URI> withSplit(InputSplit<URI> split) {
            return new TestUriInputSource((List<URI>)ImmutableList.of((Object)((URI)split.get())));
        }

        public boolean needsFormat() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TestUriInputSource that = (TestUriInputSource)((Object)o);
            return Objects.equals(this.uris, that.uris);
        }

        public int hashCode() {
            return Objects.hash(this.uris);
        }
    }

    private static class TestFileInputSource
    extends AbstractInputSource
    implements SplittableInputSource<File> {
        private final List<File> files;

        @JsonCreator
        private TestFileInputSource(@JsonProperty(value="files") List<File> fileList) {
            this.files = fileList;
        }

        @JsonIgnore
        public Set<String> getTypes() {
            return Collections.singleton("testFile");
        }

        @JsonProperty
        public List<File> getFiles() {
            return this.files;
        }

        public Stream<InputSplit<File>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return this.files.stream().map(InputSplit::new);
        }

        public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return this.files.size();
        }

        public SplittableInputSource<File> withSplit(InputSplit<File> split) {
            return new TestFileInputSource((List<File>)ImmutableList.of((Object)((File)split.get())));
        }

        public boolean needsFormat() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TestFileInputSource that = (TestFileInputSource)((Object)o);
            return Objects.equals(this.files, that.files);
        }

        public int hashCode() {
            return Objects.hash(this.files);
        }
    }
}

