/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;

public class CsvInputFormatTest
extends InitializedNullHandlingTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        CsvInputFormat format = new CsvInputFormat(Collections.singletonList("a"), "|", null, Boolean.valueOf(true), 10);
        byte[] bytes = mapper.writeValueAsBytes((Object)format);
        CsvInputFormat fromJson = (CsvInputFormat)mapper.readValue(bytes, InputFormat.class);
        Assert.assertEquals((Object)format, (Object)fromJson);
    }

    @Test
    public void testDeserializeWithoutColumnsWithHasHeaderRow() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        CsvInputFormat inputFormat = (CsvInputFormat)mapper.readValue("{\"type\":\"csv\",\"hasHeaderRow\":true}", InputFormat.class);
        Assert.assertTrue((boolean)inputFormat.isFindColumnsFromHeader());
    }

    @Test
    public void testDeserializeWithoutColumnsWithFindColumnsFromHeaderTrue() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        CsvInputFormat inputFormat = (CsvInputFormat)mapper.readValue("{\"type\":\"csv\",\"findColumnsFromHeader\":true}", InputFormat.class);
        Assert.assertTrue((boolean)inputFormat.isFindColumnsFromHeader());
    }

    @Test
    public void testDeserializeWithoutColumnsWithFindColumnsFromHeaderFalse() {
        ObjectMapper mapper = new ObjectMapper();
        JsonProcessingException e = (JsonProcessingException)Assert.assertThrows(JsonProcessingException.class, () -> mapper.readValue("{\"type\":\"csv\",\"findColumnsFromHeader\":false}", InputFormat.class));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Cannot construct instance of `org.apache.druid.data.input.impl.CsvInputFormat`, problem: If [columns] is not set, the first row of your data must have your header and [findColumnsFromHeader] must be set to true.")));
    }

    @Test
    public void testDeserializeWithoutColumnsWithBothHeaderProperties() {
        ObjectMapper mapper = new ObjectMapper();
        JsonProcessingException e = (JsonProcessingException)Assert.assertThrows(JsonProcessingException.class, () -> mapper.readValue("{\"type\":\"csv\",\"findColumnsFromHeader\":true,\"hasHeaderRow\":true}", InputFormat.class));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Cannot construct instance of `org.apache.druid.data.input.impl.CsvInputFormat`, problem: Cannot accept both [findColumnsFromHeader] and [hasHeaderRow]")));
    }

    @Test
    public void testDeserializeWithoutAnyProperties() {
        ObjectMapper mapper = new ObjectMapper();
        JsonProcessingException e = (JsonProcessingException)Assert.assertThrows(JsonProcessingException.class, () -> mapper.readValue("{\"type\":\"csv\"}", InputFormat.class));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Cannot construct instance of `org.apache.druid.data.input.impl.CsvInputFormat`, problem: Either [columns] or [findColumnsFromHeader] must be set")));
    }

    @Test
    public void testComma() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Column[a,] cannot have the delimiter[,] in its name");
        new CsvInputFormat(Collections.singletonList("a,"), "|", null, Boolean.valueOf(false), 0);
    }

    @Test
    public void testDelimiter() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot have same delimiter and list delimiter of [,]");
        new CsvInputFormat(Collections.singletonList("a\t"), ",", null, Boolean.valueOf(false), 0);
    }

    @Test
    public void testFindColumnsFromHeaderWithColumnsReturningItsValue() {
        CsvInputFormat format = new CsvInputFormat(Collections.singletonList("a"), null, null, Boolean.valueOf(true), 0);
        Assert.assertTrue((boolean)format.isFindColumnsFromHeader());
    }

    @Test
    public void testFindColumnsFromHeaderWithMissingColumnsReturningItsValue() {
        CsvInputFormat format = new CsvInputFormat(null, null, null, Boolean.valueOf(true), 0);
        Assert.assertTrue((boolean)format.isFindColumnsFromHeader());
    }

    @Test
    public void testMissingFindColumnsFromHeaderWithMissingColumnsThrowingError() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Either [columns] or [findColumnsFromHeader] must be set");
        new CsvInputFormat(null, null, null, null, 0);
    }

    @Test
    public void testMissingFindColumnsFromHeaderWithColumnsReturningFalse() {
        CsvInputFormat format = new CsvInputFormat(Collections.singletonList("a"), null, null, null, 0);
        Assert.assertFalse((boolean)format.isFindColumnsFromHeader());
    }

    @Test
    public void testHasHeaderRowWithMissingFindColumnsThrowingError() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot accept both [findColumnsFromHeader] and [hasHeaderRow]");
        new CsvInputFormat(null, null, Boolean.valueOf(true), Boolean.valueOf(false), 0);
    }

    @Test
    public void testHasHeaderRowWithMissingColumnsReturningItsValue() {
        CsvInputFormat format = new CsvInputFormat(null, null, Boolean.valueOf(true), null, 0);
        Assert.assertTrue((boolean)format.isFindColumnsFromHeader());
    }

    @Test
    public void test_getWeightedSize_withoutCompression() {
        CsvInputFormat format = new CsvInputFormat(null, null, Boolean.valueOf(true), null, 0);
        long unweightedSize = 100L;
        Assert.assertEquals((long)100L, (long)format.getWeightedSize("file.csv", 100L));
    }

    @Test
    public void test_getWeightedSize_withGzCompression() {
        CsvInputFormat format = new CsvInputFormat(null, null, Boolean.valueOf(true), null, 0);
        long unweightedSize = 100L;
        Assert.assertEquals((long)400L, (long)format.getWeightedSize("file.csv.gz", 100L));
    }
}

