/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.druid.TestObjectMapper;
import org.apache.druid.data.input.ByteBufferInputRowParser;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.junit.Assert;
import org.junit.Test;

public class InputRowParserSerdeTest {
    private final ObjectMapper jsonMapper = new TestObjectMapper();

    @Test
    public void testStringInputRowParserSerde() throws Exception {
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo", (Object)"bar"))), null, null, null), null);
        ByteBufferInputRowParser parser2 = (ByteBufferInputRowParser)this.jsonMapper.readValue(this.jsonMapper.writeValueAsBytes((Object)parser), ByteBufferInputRowParser.class);
        InputRow parsed = (InputRow)parser2.parseBatch((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"{\"foo\":\"x\",\"bar\":\"y\",\"qux\":\"z\",\"timestamp\":\"2000\"}"))).get(0);
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar"), (Object)parsed.getDimensions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"x"), (Object)parsed.getDimension("foo"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"y"), (Object)parsed.getDimension("bar"));
        Assert.assertEquals((long)DateTimes.of((String)"2000").getMillis(), (long)parsed.getTimestampFromEpoch());
    }

    @Test
    public void testStringInputRowParserSerdeMultiCharset() throws Exception {
        Charset[] testCharsets;
        for (Charset testCharset : testCharsets = new Charset[]{StandardCharsets.US_ASCII, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE, StandardCharsets.UTF_16}) {
            InputRow parsed = this.testCharsetParseHelper(testCharset);
            Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar"), (Object)parsed.getDimensions());
            Assert.assertEquals((Object)ImmutableList.of((Object)"x"), (Object)parsed.getDimension("foo"));
            Assert.assertEquals((Object)ImmutableList.of((Object)"y"), (Object)parsed.getDimension("bar"));
            Assert.assertEquals((long)DateTimes.of((String)"3000").getMillis(), (long)parsed.getTimestampFromEpoch());
        }
    }

    @Test
    public void testMapInputRowParserSerde() throws Exception {
        MapInputRowParser parser = new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timeposix", "posix", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo", (Object)"bar"))).setDimensionExclusions((List)ImmutableList.of((Object)"baz")).build(), null, null, null));
        MapInputRowParser parser2 = (MapInputRowParser)this.jsonMapper.readValue(this.jsonMapper.writeValueAsBytes((Object)parser), InputRowParser.class);
        InputRow parsed = (InputRow)parser2.parseBatch((Map)ImmutableMap.of((Object)"foo", (Object)"x", (Object)"bar", (Object)"y", (Object)"qux", (Object)"z", (Object)"timeposix", (Object)"1")).get(0);
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar"), (Object)parsed.getDimensions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"x"), (Object)parsed.getDimension("foo"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"y"), (Object)parsed.getDimension("bar"));
        Assert.assertEquals((long)1000L, (long)parsed.getTimestampFromEpoch());
    }

    @Test
    public void testMapInputRowParserNumbersSerde() throws Exception {
        MapInputRowParser parser = new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timemillis", "millis", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo", (Object)"values"))).setDimensionExclusions((List)ImmutableList.of((Object)"toobig", (Object)"value")).build(), null, null, null));
        MapInputRowParser parser2 = (MapInputRowParser)this.jsonMapper.readValue(this.jsonMapper.writeValueAsBytes((Object)parser), InputRowParser.class);
        InputRow parsed = (InputRow)parser2.parseBatch((Map)ImmutableMap.of((Object)"timemillis", (Object)1412705931123L, (Object)"toobig", (Object)1.23E66, (Object)"value", (Object)123.456, (Object)"long", (Object)123456789000L, (Object)"values", (Object)Lists.newArrayList((Object[])new Serializable[]{Long.valueOf(1412705931123L), Double.valueOf(123.456), Double.valueOf(1.23E47), "hello"}))).get(0);
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"values"), (Object)parsed.getDimensions());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)parsed.getDimension("foo"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"1412705931123", (Object)"123.456", (Object)"1.23E47", (Object)"hello"), (Object)parsed.getDimension("values"));
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)parsed.getMetric("toobig").floatValue(), (double)0.0);
        Assert.assertEquals((Object)1.23E66, (Object)parsed.getRaw("toobig"));
        Assert.assertEquals((float)123.456f, (float)parsed.getMetric("value").floatValue(), (float)0.0f);
        Assert.assertEquals((Object)123456789000L, (Object)parsed.getRaw("long"));
        Assert.assertEquals((float)1.2345679E11f, (float)parsed.getMetric("long").floatValue(), (float)0.0f);
        Assert.assertEquals((long)1412705931123L, (long)parsed.getTimestampFromEpoch());
    }

    private InputRow testCharsetParseHelper(Charset charset) throws Exception {
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo", (Object)"bar"))), null, null, null), charset.name());
        ByteBufferInputRowParser parser2 = (ByteBufferInputRowParser)this.jsonMapper.readValue(this.jsonMapper.writeValueAsBytes((Object)parser), ByteBufferInputRowParser.class);
        InputRow parsed = (InputRow)parser2.parseBatch((Object)ByteBuffer.wrap("{\"foo\":\"x\",\"bar\":\"y\",\"qux\":\"z\",\"timestamp\":\"3000\"}".getBytes(charset))).get(0);
        return parsed;
    }

    @Test
    public void testFlattenParse() throws Exception {
        ArrayList<JSONPathFieldSpec> fields = new ArrayList<JSONPathFieldSpec>();
        fields.add(JSONPathFieldSpec.createNestedField((String)"foobar1", (String)"$.foo.bar1"));
        fields.add(JSONPathFieldSpec.createNestedField((String)"foobar2", (String)"$.foo.bar2"));
        fields.add(JSONPathFieldSpec.createNestedField((String)"baz0", (String)"$.baz[0]"));
        fields.add(JSONPathFieldSpec.createNestedField((String)"baz1", (String)"$.baz[1]"));
        fields.add(JSONPathFieldSpec.createNestedField((String)"baz2", (String)"$.baz[2]"));
        fields.add(JSONPathFieldSpec.createNestedField((String)"hey0barx", (String)"$.hey[0].barx"));
        fields.add(JSONPathFieldSpec.createNestedField((String)"metA", (String)"$.met.a"));
        fields.add(JSONPathFieldSpec.createNestedField((String)"missing", (String)"$.nonexistent.nested.field"));
        fields.add(JSONPathFieldSpec.createRootField((String)"timestamp"));
        fields.add(JSONPathFieldSpec.createRootField((String)"foo.bar1"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(true), fields);
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timestamp", "iso", null), DimensionsSpec.EMPTY, flattenSpec, null, null), null);
        StringInputRowParser parser2 = (StringInputRowParser)this.jsonMapper.readValue(this.jsonMapper.writeValueAsBytes((Object)parser), StringInputRowParser.class);
        InputRow parsed = parser2.parse("{\"blah\":[4,5,6], \"newmet\":5, \"foo\":{\"bar1\":\"aaa\", \"bar2\":\"bbb\"}, \"baz\":[1,2,3], \"timestamp\":\"2999\", \"foo.bar1\":\"Hello world!\", \"hey\":[{\"barx\":\"asdf\"}], \"met\":{\"a\":456}}");
        Assert.assertEquals((Object)ImmutableList.of((Object)"foobar1", (Object)"foobar2", (Object)"baz0", (Object)"baz1", (Object)"baz2", (Object)"hey0barx", (Object)"metA", (Object)"missing", (Object)"foo.bar1", (Object)"blah", (Object)"newmet", (Object)"baz", (Object[])new String[0]), (Object)parsed.getDimensions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"aaa"), (Object)parsed.getDimension("foobar1"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"bbb"), (Object)parsed.getDimension("foobar2"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"1"), (Object)parsed.getDimension("baz0"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"2"), (Object)parsed.getDimension("baz1"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"3"), (Object)parsed.getDimension("baz2"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"Hello world!"), (Object)parsed.getDimension("foo.bar1"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"asdf"), (Object)parsed.getDimension("hey0barx"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"456"), (Object)parsed.getDimension("metA"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"5"), (Object)parsed.getDimension("newmet"));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)parsed.getDimension("missing"));
        Assert.assertEquals((long)DateTimes.of((String)"2999").getMillis(), (long)parsed.getTimestampFromEpoch());
        String testSpec = "{\"enabled\": true,\"useFieldDiscovery\": true, \"fields\": [\"parseThisRootField\"]}";
        JSONPathSpec parsedSpec = (JSONPathSpec)this.jsonMapper.readValue(testSpec, JSONPathSpec.class);
        List fieldSpecs = parsedSpec.getFields();
        Assert.assertEquals((Object)JSONPathFieldType.ROOT, (Object)((JSONPathFieldSpec)fieldSpecs.get(0)).getType());
        Assert.assertEquals((Object)"parseThisRootField", (Object)((JSONPathFieldSpec)fieldSpecs.get(0)).getName());
        Assert.assertEquals((Object)"parseThisRootField", (Object)((JSONPathFieldSpec)fieldSpecs.get(0)).getExpr());
    }
}

