/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.junit.Assert;
import org.junit.Test;

public class JsonInputFormatTest {
    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz", "baz"), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz2", "baz2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg2", "$.o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg", ".o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg2", ".o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg", null, Arrays.asList("o", "mg")), (Object)new JSONPathFieldSpec(JSONPathFieldType.TREE, "tree_omg2", null, Arrays.asList("o", "mg2")))), (Map)ImmutableMap.of((Object)JsonParser.Feature.ALLOW_COMMENTS.name(), (Object)true, (Object)JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES.name(), (Object)false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        byte[] bytes = mapper.writeValueAsBytes((Object)format);
        JsonInputFormat fromJson = (JsonInputFormat)mapper.readValue(bytes, InputFormat.class);
        Assert.assertEquals((Object)format, (Object)fromJson);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(JsonInputFormat.class).usingGetClass().withPrefabValues(ObjectMapper.class, (Object)new ObjectMapper(), (Object)new ObjectMapper()).withIgnoredFields(new String[]{"objectMapper"}).verify();
    }

    @Test
    public void test_unsetUseFieldDiscovery_unsetKeepNullColumnsByDefault() {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(false), null), null, null, null, null);
        Assert.assertFalse((boolean)format.isKeepNullColumns());
    }

    @Test
    public void testUseFieldDiscovery_setKeepNullColumnsByDefault() {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), null), null, null, null, null);
        Assert.assertTrue((boolean)format.isKeepNullColumns());
    }

    @Test
    public void testUseFieldDiscovery_doNotChangeKeepNullColumnsUserSets() {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), null), null, Boolean.valueOf(false), null, null);
        Assert.assertFalse((boolean)format.isKeepNullColumns());
    }

    @Test
    public void test_getWeightedSize_withoutCompression() {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), null), null, Boolean.valueOf(false), null, null);
        long unweightedSize = 100L;
        Assert.assertEquals((long)100L, (long)format.getWeightedSize("file.json", 100L));
    }

    @Test
    public void test_getWeightedSize_withGzCompression() {
        JsonInputFormat format = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), null), null, Boolean.valueOf(false), null, null);
        long unweightedSize = 100L;
        Assert.assertEquals((long)400L, (long)format.getWeightedSize("file.json.gz", 100L));
    }
}

