/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.LongFieldReader;
import org.apache.druid.frame.field.LongFieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class LongFieldReaderTest
extends InitializedNullHandlingTest {
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public BaseLongColumnValueSelector writeSelector;
    private WritableMemory memory;
    private FieldWriter fieldWriter;

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = LongFieldWriter.forPrimitive((BaseLongColumnValueSelector)this.writeSelector);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
    }

    @Test
    public void test_isNull_defaultOrNull() {
        this.writeToMemory(NullHandling.defaultLongValue());
        Assert.assertEquals((Object)NullHandling.sqlCompatible(), (Object)LongFieldReader.forPrimitive().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_aValue() {
        this.writeToMemory(5L);
        Assert.assertFalse((boolean)LongFieldReader.forPrimitive().isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_makeColumnValueSelector_defaultOrNull() {
        this.writeToMemory(NullHandling.defaultLongValue());
        ColumnValueSelector readSelector = LongFieldReader.forPrimitive().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        Assert.assertEquals((Object)(!NullHandling.replaceWithDefault() ? 1 : 0), (Object)readSelector.isNull());
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)NullHandling.defaultLongValue(), (long)readSelector.getLong());
        }
    }

    @Test
    public void test_makeColumnValueSelector_aValue() {
        this.writeToMemory(5L);
        ColumnValueSelector readSelector = LongFieldReader.forPrimitive().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        Assert.assertEquals((Object)5L, (Object)readSelector.getObject());
    }

    @Test
    public void test_makeDimensionSelector_defaultOrNull() {
        this.writeToMemory(NullHandling.defaultLongValue());
        DimensionSelector readSelector = LongFieldReader.forPrimitive().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L), null);
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? "0" : null), (Object)readSelector.lookupName(0));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(String.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        if (NullHandling.replaceWithDefault()) {
            Assert.assertTrue((boolean)readSelector.makeValueMatcher("0").matches(false));
            Assert.assertFalse((boolean)readSelector.makeValueMatcher((String)null).matches(false));
            Assert.assertTrue((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"0")).matches(false));
            Assert.assertFalse((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.of((DruidObjectPredicate)DruidObjectPredicate.isNull())).matches(false));
        } else {
            Assert.assertFalse((boolean)readSelector.makeValueMatcher("0").matches(false));
            Assert.assertTrue((boolean)readSelector.makeValueMatcher((String)null).matches(false));
            Assert.assertFalse((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"0")).matches(false));
            Assert.assertTrue((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.of((DruidObjectPredicate)DruidObjectPredicate.isNull())).matches(false));
        }
    }

    @Test
    public void test_makeDimensionSelector_aValue() {
        this.writeToMemory(5L);
        DimensionSelector readSelector = LongFieldReader.forPrimitive().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L), null);
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)"5", (Object)readSelector.lookupName(0));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(String.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("5").matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("2").matches(false));
        Assert.assertTrue((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"5")).matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"2")).matches(false));
    }

    @Test
    public void test_makeDimensionSelector_aValue_extractionFn() {
        this.writeToMemory(25L);
        DimensionSelector readSelector = LongFieldReader.forPrimitive().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L), (ExtractionFn)new SubstringDimExtractionFn(1, null));
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)"5", (Object)readSelector.lookupName(0));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(String.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("5").matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("2").matches(false));
        Assert.assertTrue((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"5")).matches(false));
        Assert.assertFalse((boolean)readSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)"2")).matches(false));
    }

    private void writeToMemory(Long value) {
        Mockito.when((Object)this.writeSelector.isNull()).thenReturn((Object)(value == null ? 1 : 0));
        if (value != null) {
            Mockito.when((Object)this.writeSelector.getLong()).thenReturn((Object)value);
        }
        if (this.fieldWriter.writeTo(this.memory, 1L, this.memory.getCapacity() - 1L) < 0L) {
            throw new ISE("Could not write", new Object[0]);
        }
    }
}

