/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.FieldReaders;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.field.StringArrayFieldWriter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class StringArrayFieldWriterTest
extends InitializedNullHandlingTest {
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public BaseObjectColumnValueSelector<List<String>> selector;
    private WritableMemory memory;
    private FieldWriter fieldWriter;

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = new StringArrayFieldWriter(this.selector);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
    }

    @Test
    public void testEmptyArray() {
        this.doTest(Collections.emptyList());
    }

    @Test
    public void testNullArray() {
        this.doTest(null);
    }

    @Test
    public void testOneString() {
        this.doTest(Collections.singletonList("foo"));
    }

    @Test
    public void testOneNull() {
        this.doTest(Collections.singletonList(null));
    }

    @Test
    public void testMultiValueString() {
        this.doTest(Arrays.asList("foo", "bar"));
    }

    @Test
    public void testMultiValueStringContainingNulls() {
        this.doTest(Arrays.asList("foo", NullHandling.emptyToNullIfNeeded((String)""), "bar", null));
    }

    private void doTest(@Nullable List<String> values) {
        this.mockSelector(values);
        long written = this.writeToMemory(this.fieldWriter);
        List<String> valuesRead = this.readFromMemory(written);
        Assert.assertEquals((String)"values read", values, valuesRead);
    }

    private void mockSelector(@Nullable List<String> values) {
        Mockito.when((Object)((List)this.selector.getObject())).thenReturn(values);
    }

    private long writeToMemory(FieldWriter writer) {
        for (long maxSize = 0L; maxSize < this.memory.getCapacity() - 1L; ++maxSize) {
            long written = writer.writeTo(this.memory, 1L, maxSize);
            if (written <= 0L) continue;
            Assert.assertEquals((String)"bytes written", (long)maxSize, (long)written);
            return written;
        }
        throw new ISE("Could not write in memory with capacity [%,d]", new Object[]{this.memory.getCapacity() - 1L});
    }

    @Nullable
    private List<String> readFromMemory(long written) {
        byte[] bytes = new byte[(int)written];
        this.memory.getByteArray(1L, bytes, 0, (int)written);
        FieldReader fieldReader = FieldReaders.create((String)"columnNameDoesntMatterHere", (ColumnType)ColumnType.STRING_ARRAY);
        ColumnValueSelector selector = fieldReader.makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        Object o = selector.getObject();
        return o == null ? null : Arrays.asList((Object[])o);
    }
}

