/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.FieldReaders;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.field.StringFieldWriter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.RangeIndexedInts;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class StringFieldWriterTest
extends InitializedNullHandlingTest {
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public DimensionSelector selector;
    @Mock
    public DimensionSelector selectorUtf8;
    private WritableMemory memory;
    private FieldWriter fieldWriter;
    private FieldWriter fieldWriterUtf8;

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = new StringFieldWriter(this.selector);
        this.fieldWriterUtf8 = new StringFieldWriter(this.selectorUtf8);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
        this.fieldWriterUtf8.close();
    }

    @Test
    public void testEmptyList() {
        this.doTest(Collections.emptyList());
    }

    @Test
    public void testOneString() {
        this.doTest(Collections.singletonList("foo"));
    }

    @Test
    public void testOneNull() {
        this.doTest(Collections.singletonList(null));
    }

    @Test
    public void testMultiValueString() {
        this.doTest(Arrays.asList("foo", "bar"));
    }

    @Test
    public void testMultiValueStringContainingNulls() {
        this.doTest(Arrays.asList("foo", NullHandling.emptyToNullIfNeeded((String)""), "bar", null));
    }

    private void doTest(List<String> values) {
        this.mockSelectors(values);
        long written = this.writeToMemory(this.fieldWriter);
        Object[] valuesRead = this.readFromMemory(written);
        Assert.assertEquals((String)"values read (non-UTF8)", values, Arrays.asList(valuesRead));
        long writtenUtf8 = this.writeToMemory(this.fieldWriterUtf8);
        Object[] valuesReadUtf8 = this.readFromMemory(writtenUtf8);
        Assert.assertEquals((String)"values read (UTF8)", values, Arrays.asList(valuesReadUtf8));
    }

    private void mockSelectors(List<String> values) {
        RangeIndexedInts row = new RangeIndexedInts();
        row.setSize(values.size());
        Mockito.when((Object)this.selector.getRow()).thenReturn((Object)row);
        Mockito.when((Object)this.selectorUtf8.getRow()).thenReturn((Object)row);
        if (values.size() > 0) {
            Mockito.when((Object)this.selector.supportsLookupNameUtf8()).thenReturn((Object)false);
            Mockito.when((Object)this.selectorUtf8.supportsLookupNameUtf8()).thenReturn((Object)true);
        }
        for (int i = 0; i < values.size(); ++i) {
            ByteBuffer buf;
            String value = values.get(i);
            Mockito.when((Object)this.selector.lookupName(i)).thenReturn((Object)value);
            if (value == null) {
                buf = null;
            } else {
                byte[] valueBytes = StringUtils.toUtf8((String)value);
                buf = ByteBuffer.allocate(value.length() + 2);
                buf.put(0, (byte)88);
                buf.put(buf.capacity() - 1, (byte)88);
                buf.position(1);
                buf.put(valueBytes);
                buf.position(1);
                buf.limit(buf.capacity() - 1);
            }
            Mockito.when((Object)this.selectorUtf8.lookupNameUtf8(i)).then(invocation -> buf == null ? null : buf.duplicate());
        }
    }

    private long writeToMemory(FieldWriter writer) {
        for (long maxSize = 0L; maxSize < this.memory.getCapacity() - 1L; ++maxSize) {
            long written = writer.writeTo(this.memory, 1L, maxSize);
            if (written <= 0L) continue;
            Assert.assertEquals((String)"bytes written", (long)maxSize, (long)written);
            return written;
        }
        throw new ISE("Could not write in memory with capacity [%,d]", new Object[]{this.memory.getCapacity() - 1L});
    }

    private Object[] readFromMemory(long written) {
        byte[] bytes = new byte[(int)written];
        this.memory.getByteArray(1L, bytes, 0, (int)written);
        FieldReader fieldReader = FieldReaders.create((String)"columnNameDoesntMatterHere", (ColumnType)ColumnType.STRING_ARRAY);
        ColumnValueSelector selector = fieldReader.makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, -1L));
        return (Object[])selector.getObject();
    }
}

