/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.file;

import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.io.File;
import java.io.IOException;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.channel.ReadableByteChunksFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.file.FrameFileHttpResponseHandler;
import org.apache.druid.frame.file.FrameFilePartialFetch;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ByteBufferBackedChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FrameFileHttpResponseHandlerTest
extends InitializedNullHandlingTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final int maxRowsPerFrame;
    private StorageAdapter adapter;
    private File file;
    private ReadableByteChunksFrameChannel channel;
    private FrameFileHttpResponseHandler handler;

    public FrameFileHttpResponseHandlerTest(int maxRowsPerFrame) {
        this.maxRowsPerFrame = maxRowsPerFrame;
    }

    @Parameterized.Parameters(name="maxRowsPerFrame = {0}")
    public static Iterable<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (int maxRowsPerFrame : new int[]{1, 50, Integer.MAX_VALUE}) {
            constructors.add(new Object[]{maxRowsPerFrame});
        }
        return constructors;
    }

    @Before
    public void setUp() throws IOException {
        this.adapter = new IncrementalIndexStorageAdapter(TestIndex.getIncrementalTestIndex());
        this.file = FrameTestUtil.writeFrameFile(FrameSequenceBuilder.fromAdapter(this.adapter).maxRowsPerFrame(this.maxRowsPerFrame).frameType(FrameType.ROW_BASED).frames(), this.temporaryFolder.newFile());
        this.channel = ReadableByteChunksFrameChannel.create((String)"test", (boolean)false);
        this.handler = new FrameFileHttpResponseHandler(this.channel);
    }

    @Test
    public void testNonChunkedResponse() throws Exception {
        ClientResponse response1 = this.handler.handleResponse(FrameFileHttpResponseHandlerTest.makeResponse(HttpResponseStatus.OK, Files.readAllBytes(this.file.toPath())), null);
        Assert.assertFalse((boolean)response1.isFinished());
        Assert.assertTrue((boolean)response1.isContinueReading());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response1.getObj()).isExceptionCaught());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response1.getObj()).isLastFetch());
        ClientResponse response2 = this.handler.done(response1);
        Assert.assertTrue((boolean)response2.isFinished());
        Assert.assertTrue((boolean)response2.isContinueReading());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response2.getObj()).isExceptionCaught());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response2.getObj()).isLastFetch());
        ListenableFuture backpressureFuture = ((FrameFilePartialFetch)response2.getObj()).backpressureFuture();
        Assert.assertFalse((boolean)backpressureFuture.isDone());
        this.channel.doneWriting();
        FrameTestUtil.assertRowsEqual(FrameTestUtil.readRowsFromAdapter(this.adapter, null, false), FrameTestUtil.readRowsFromFrameChannel((ReadableFrameChannel)this.channel, FrameReader.create((RowSignature)this.adapter.getRowSignature())));
        Assert.assertTrue((boolean)backpressureFuture.isDone());
    }

    @Test
    public void testEmptyResponseWithoutLastFetchHeader() {
        ClientResponse response1 = this.handler.handleResponse(FrameFileHttpResponseHandlerTest.makeResponse(HttpResponseStatus.OK, ByteArrays.EMPTY_ARRAY), null);
        Assert.assertFalse((boolean)response1.isFinished());
        Assert.assertTrue((boolean)response1.isContinueReading());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response1.getObj()).isExceptionCaught());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response1.getObj()).isLastFetch());
        ClientResponse response2 = this.handler.done(response1);
        Assert.assertTrue((boolean)response2.isFinished());
        Assert.assertTrue((boolean)response2.isContinueReading());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response2.getObj()).isExceptionCaught());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response2.getObj()).isLastFetch());
        Assert.assertTrue((boolean)((FrameFilePartialFetch)response2.getObj()).backpressureFuture().isDone());
    }

    @Test
    public void testEmptyResponseWithLastFetchHeader() {
        HttpResponse serverResponse = FrameFileHttpResponseHandlerTest.makeResponse(HttpResponseStatus.OK, ByteArrays.EMPTY_ARRAY);
        serverResponse.headers().set("X-Druid-Frame-Last-Fetch", (Object)"yes");
        ClientResponse response1 = this.handler.handleResponse(serverResponse, null);
        Assert.assertFalse((boolean)response1.isFinished());
        Assert.assertTrue((boolean)response1.isContinueReading());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response1.getObj()).isExceptionCaught());
        Assert.assertTrue((boolean)((FrameFilePartialFetch)response1.getObj()).isLastFetch());
        ClientResponse response2 = this.handler.done(response1);
        Assert.assertTrue((boolean)response2.isFinished());
        Assert.assertTrue((boolean)response2.isContinueReading());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response2.getObj()).isExceptionCaught());
        Assert.assertTrue((boolean)((FrameFilePartialFetch)response2.getObj()).isLastFetch());
        Assert.assertTrue((boolean)((FrameFilePartialFetch)response2.getObj()).backpressureFuture().isDone());
    }

    @Test
    public void testChunkedResponse() throws Exception {
        int chunkSize = 99;
        byte[] allBytes = Files.readAllBytes(this.file.toPath());
        ClientResponse response = this.handler.handleResponse(FrameFileHttpResponseHandlerTest.makeResponse(HttpResponseStatus.OK, FrameFileHttpResponseHandlerTest.byteSlice(allBytes, 0, 99)), null);
        Assert.assertFalse((boolean)response.isFinished());
        for (int p = 99; p < allBytes.length; p += 99) {
            response = this.handler.handleChunk(response, FrameFileHttpResponseHandlerTest.makeChunk(FrameFileHttpResponseHandlerTest.byteSlice(allBytes, p, 99)), (long)(p / 99));
            Assert.assertFalse((boolean)response.isFinished());
            Assert.assertFalse((boolean)((FrameFilePartialFetch)response.getObj()).isExceptionCaught());
            Assert.assertFalse((boolean)((FrameFilePartialFetch)response.getObj()).isLastFetch());
        }
        ClientResponse finalResponse = this.handler.done(response);
        Assert.assertTrue((boolean)finalResponse.isFinished());
        Assert.assertTrue((boolean)finalResponse.isContinueReading());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response.getObj()).isExceptionCaught());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response.getObj()).isLastFetch());
        ListenableFuture backpressureFuture = ((FrameFilePartialFetch)response.getObj()).backpressureFuture();
        Assert.assertFalse((boolean)backpressureFuture.isDone());
        this.channel.doneWriting();
        FrameTestUtil.assertRowsEqual(FrameTestUtil.readRowsFromAdapter(this.adapter, null, false), FrameTestUtil.readRowsFromFrameChannel((ReadableFrameChannel)this.channel, FrameReader.create((RowSignature)this.adapter.getRowSignature())));
        Assert.assertTrue((boolean)backpressureFuture.isDone());
    }

    @Test
    public void testServerErrorResponse() {
        ClientResponse response = this.handler.handleResponse(FrameFileHttpResponseHandlerTest.makeResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, StringUtils.toUtf8((String)"Oh no!")), null);
        ClientResponse finalResponse = this.handler.done(response);
        Assert.assertTrue((boolean)finalResponse.isFinished());
        Assert.assertTrue((boolean)finalResponse.isContinueReading());
        Assert.assertTrue((boolean)((FrameFilePartialFetch)finalResponse.getObj()).isExceptionCaught());
        Throwable e = ((FrameFilePartialFetch)finalResponse.getObj()).getExceptionCaught();
        MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Server for [test] returned [500 Internal Server Error]")));
        Assert.assertFalse((boolean)this.channel.isErrorOrFinished());
    }

    @Test
    public void testChunkedServerErrorResponse() {
        ClientResponse response = this.handler.handleResponse(FrameFileHttpResponseHandlerTest.makeResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, StringUtils.toUtf8((String)"Oh ")), null);
        response = this.handler.handleChunk(response, FrameFileHttpResponseHandlerTest.makeChunk(StringUtils.toUtf8((String)"no!")), 1L);
        ClientResponse finalResponse = this.handler.done(response);
        Assert.assertTrue((boolean)finalResponse.isFinished());
        Assert.assertTrue((boolean)finalResponse.isContinueReading());
        Assert.assertTrue((boolean)((FrameFilePartialFetch)finalResponse.getObj()).isExceptionCaught());
        Throwable e = ((FrameFilePartialFetch)finalResponse.getObj()).getExceptionCaught();
        MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Server for [test] returned [500 Internal Server Error]")));
        Assert.assertFalse((boolean)this.channel.isErrorOrFinished());
    }

    @Test
    public void testCaughtExceptionDuringChunkedResponse() throws Exception {
        int chunkSize = Ints.checkedCast((long)LongMath.divide((long)this.file.length(), (long)4L, (RoundingMode)RoundingMode.CEILING));
        byte[] allBytes = Files.readAllBytes(this.file.toPath());
        ClientResponse response = this.handler.handleResponse(FrameFileHttpResponseHandlerTest.makeResponse(HttpResponseStatus.OK, FrameFileHttpResponseHandlerTest.byteSlice(allBytes, 0, chunkSize)), null);
        Assert.assertFalse((boolean)response.isFinished());
        response = this.handler.handleChunk(response, FrameFileHttpResponseHandlerTest.makeChunk(FrameFileHttpResponseHandlerTest.byteSlice(allBytes, chunkSize, chunkSize)), 1L);
        this.handler.exceptionCaught(response, (Throwable)new ISE("Oh no!", new Object[0]));
        this.handler.handleChunk(response, FrameFileHttpResponseHandlerTest.makeChunk(FrameFileHttpResponseHandlerTest.byteSlice(allBytes, chunkSize * 2, chunkSize)), 2L);
        Assert.assertTrue((boolean)((FrameFilePartialFetch)response.getObj()).isExceptionCaught());
        Throwable e = ((FrameFilePartialFetch)response.getObj()).getExceptionCaught();
        MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Oh no!")));
        Assert.assertFalse((boolean)this.channel.isErrorOrFinished());
        this.channel.addChunk(FrameFileHttpResponseHandlerTest.byteSlice(allBytes, chunkSize * 2, chunkSize));
        this.channel.addChunk(FrameFileHttpResponseHandlerTest.byteSlice(allBytes, chunkSize * 3, chunkSize));
        Assert.assertEquals((long)allBytes.length, (long)this.channel.getBytesAdded());
        this.channel.doneWriting();
        FrameTestUtil.assertRowsEqual(FrameTestUtil.readRowsFromAdapter(this.adapter, null, false), FrameTestUtil.readRowsFromFrameChannel((ReadableFrameChannel)this.channel, FrameReader.create((RowSignature)this.adapter.getRowSignature())));
    }

    @Test
    public void testCaughtExceptionDuringChunkedResponseRetryWithSameHandler() throws Exception {
        int firstPart = 100;
        int chunkSize = Ints.checkedCast((long)LongMath.divide((long)(this.file.length() - 100L), (long)12L, (RoundingMode)RoundingMode.CEILING));
        byte[] allBytes = Files.readAllBytes(this.file.toPath());
        ClientResponse response = this.handler.done(this.handler.handleResponse(FrameFileHttpResponseHandlerTest.makeResponse(HttpResponseStatus.OK, FrameFileHttpResponseHandlerTest.byteSlice(allBytes, 0, 100)), null));
        Assert.assertEquals((long)100L, (long)this.channel.getBytesAdded());
        Assert.assertTrue((boolean)response.isFinished());
        this.handler = new FrameFileHttpResponseHandler(this.channel);
        response = this.handler.handleResponse(FrameFileHttpResponseHandlerTest.makeResponse(HttpResponseStatus.OK, FrameFileHttpResponseHandlerTest.byteSlice(allBytes, 100, chunkSize * 3)), null);
        this.handler.exceptionCaught(response, (Throwable)new ISE("Oh no!", new Object[0]));
        response = this.handler.handleChunk(response, FrameFileHttpResponseHandlerTest.makeChunk(FrameFileHttpResponseHandlerTest.byteSlice(allBytes, 100 + chunkSize * 3, chunkSize * 3)), 2L);
        Assert.assertTrue((boolean)((FrameFilePartialFetch)response.getObj()).isExceptionCaught());
        Throwable e = ((FrameFilePartialFetch)response.getObj()).getExceptionCaught();
        MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Oh no!")));
        response = this.handler.handleResponse(FrameFileHttpResponseHandlerTest.makeResponse(HttpResponseStatus.OK, FrameFileHttpResponseHandlerTest.byteSlice(allBytes, 100, chunkSize * 4)), null);
        Assert.assertEquals((long)(100L + (long)chunkSize * 4L), (long)this.channel.getBytesAdded());
        Assert.assertFalse((boolean)response.isFinished());
        response = this.handler.handleChunk(response, FrameFileHttpResponseHandlerTest.makeChunk(FrameFileHttpResponseHandlerTest.byteSlice(allBytes, 100 + chunkSize * 4, chunkSize * 4)), 1L);
        Assert.assertEquals((long)(100L + (long)chunkSize * 8L), (long)this.channel.getBytesAdded());
        response = this.handler.handleChunk(response, FrameFileHttpResponseHandlerTest.makeChunk(FrameFileHttpResponseHandlerTest.byteSlice(allBytes, 100 + chunkSize * 8, chunkSize * 4)), 2L);
        response = this.handler.done(response);
        Assert.assertTrue((boolean)response.isFinished());
        Assert.assertFalse((boolean)((FrameFilePartialFetch)response.getObj()).isExceptionCaught());
        Assert.assertEquals((long)allBytes.length, (long)this.channel.getBytesAdded());
        this.channel.doneWriting();
        FrameTestUtil.assertRowsEqual(FrameTestUtil.readRowsFromAdapter(this.adapter, null, false), FrameTestUtil.readRowsFromFrameChannel((ReadableFrameChannel)this.channel, FrameReader.create((RowSignature)this.adapter.getRowSignature())));
    }

    private static HttpResponse makeResponse(HttpResponseStatus status, byte[] content) {
        final ByteBufferBackedChannelBuffer channelBuffer = new ByteBufferBackedChannelBuffer(ByteBuffer.wrap(content));
        return new DefaultHttpResponse(HttpVersion.HTTP_1_1, status){

            public ChannelBuffer getContent() {
                return channelBuffer;
            }
        };
    }

    private static HttpChunk makeChunk(byte[] content) {
        ByteBufferBackedChannelBuffer channelBuffer = new ByteBufferBackedChannelBuffer(ByteBuffer.wrap(content));
        return new DefaultHttpChunk((ChannelBuffer)channelBuffer);
    }

    private static byte[] byteSlice(byte[] bytes, int start, int length) {
        int actualLength = Math.min(bytes.length - start, length);
        byte[] retVal = new byte[actualLength];
        System.arraycopy(bytes, start, retVal, 0, actualLength);
        return retVal;
    }
}

