/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.ComposingOutputChannelFactory;
import org.apache.druid.frame.processor.FileOutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannelFactoryTest;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ComposingOutputChannelFactoryTest
extends OutputChannelFactoryTest {
    @ClassRule
    public static TemporaryFolder folder = new TemporaryFolder();

    public ComposingOutputChannelFactoryTest() throws IOException {
        super((OutputChannelFactory)new ComposingOutputChannelFactory((List)ImmutableList.of((Object)new FileOutputChannelFactory(folder.newFolder(), 100, new ByteTracker(256000L)), (Object)new FileOutputChannelFactory(folder.newFolder(), 100, new ByteTracker(256000L))), 100), 100L);
    }

    @Test
    public void test_openChannel2() throws IOException, ExecutionException, InterruptedException {
        ComposingOutputChannelFactory outputChannelFactory = new ComposingOutputChannelFactory((List)ImmutableList.of((Object)new FileOutputChannelFactory(folder.newFolder(), 100, new ByteTracker(1L)), (Object)new ThrowingOutputChannelFactory()), 100);
        OutputChannel channel = outputChannelFactory.openChannel(1);
        Assert.assertEquals((long)1L, (long)channel.getPartitionNumber());
        WritableFrameChannel writableFrameChannel = channel.getWritableChannel();
        writableFrameChannel.writabilityFuture().get();
        Assert.assertThrows(UnsupportedOperationException.class, () -> writableFrameChannel.write(new FrameWithPartition(this.frame, 1)));
    }

    @Test
    public void test_openChannel3() throws IOException, ExecutionException, InterruptedException {
        ComposingOutputChannelFactory outputChannelFactory = new ComposingOutputChannelFactory((List)ImmutableList.of((Object)new FileOutputChannelFactory(folder.newFolder(), 100, new ByteTracker(1000000L)), (Object)new ThrowingOutputChannelFactory()), 100);
        OutputChannel channel = outputChannelFactory.openChannel(1);
        Assert.assertEquals((long)1L, (long)channel.getPartitionNumber());
        WritableFrameChannel writableFrameChannel = channel.getWritableChannel();
        writableFrameChannel.writabilityFuture().get();
        writableFrameChannel.write(new FrameWithPartition(this.frame, 1));
        writableFrameChannel.close();
        this.verifySingleFrameReadableChannel(channel.getReadableChannel(), this.sourceAdapter);
    }

    private static class ThrowingOutputChannelFactory
    implements OutputChannelFactory {
        private ThrowingOutputChannelFactory() {
        }

        public OutputChannel openChannel(int partitionNumber) {
            throw new UnsupportedOperationException();
        }

        public PartitionedOutputChannel openPartitionedChannel(String name, boolean deleteAfterRead) {
            throw new UnsupportedOperationException();
        }

        public OutputChannel openNilChannel(int partitionNumber) {
            throw new UnsupportedOperationException();
        }
    }
}

