/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.manager;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.processor.manager.ProcessorAndCallback;
import org.apache.druid.frame.processor.manager.SequenceProcessorManager;
import org.apache.druid.java.util.common.Unit;
import org.apache.druid.java.util.common.guava.Sequences;
import org.junit.Assert;
import org.junit.Test;

public class SequenceProcessorManagerTest {
    @Test
    public void test_empty() throws Exception {
        AtomicLong closed = new AtomicLong();
        try (SequenceProcessorManager manager = new SequenceProcessorManager(Sequences.empty().withBaggage(closed::getAndIncrement));){
            ListenableFuture future = manager.next();
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertFalse((boolean)((Optional)future.get()).isPresent());
        }
        Assert.assertEquals((long)1L, (long)closed.get());
    }

    @Test
    public void test_one() throws Exception {
        NilFrameProcessor processor = new NilFrameProcessor();
        AtomicLong closed = new AtomicLong();
        try (SequenceProcessorManager manager = new SequenceProcessorManager(Sequences.simple(Collections.singleton(processor)).withBaggage(closed::getAndIncrement));){
            ListenableFuture future = manager.next();
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertTrue((boolean)((Optional)future.get()).isPresent());
            Assert.assertSame((Object)processor, (Object)((ProcessorAndCallback)((Optional)future.get()).get()).processor());
            future = manager.next();
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertFalse((boolean)((Optional)future.get()).isPresent());
        }
        Assert.assertEquals((long)1L, (long)closed.get());
    }

    @Test
    public void test_two() throws Exception {
        NilFrameProcessor processor0 = new NilFrameProcessor();
        NilFrameProcessor processor1 = new NilFrameProcessor();
        AtomicLong closed = new AtomicLong();
        try (SequenceProcessorManager manager = new SequenceProcessorManager(Sequences.simple((Iterable)ImmutableList.of((Object)processor0, (Object)processor1)).withBaggage(closed::getAndIncrement));){
            ListenableFuture future = manager.next();
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertTrue((boolean)((Optional)future.get()).isPresent());
            Assert.assertSame((Object)processor0, (Object)((ProcessorAndCallback)((Optional)future.get()).get()).processor());
            future = manager.next();
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertTrue((boolean)((Optional)future.get()).isPresent());
            Assert.assertSame((Object)processor1, (Object)((ProcessorAndCallback)((Optional)future.get()).get()).processor());
            future = manager.next();
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertFalse((boolean)((Optional)future.get()).isPresent());
            Assert.assertThrows(NoSuchElementException.class, () -> ((SequenceProcessorManager)manager).next());
        }
        Assert.assertEquals((long)1L, (long)closed.get());
    }

    @Test
    public void test_empty_closeThenNext() {
        AtomicLong closed = new AtomicLong();
        SequenceProcessorManager manager = new SequenceProcessorManager(Sequences.empty().withBaggage(closed::getAndIncrement));
        manager.close();
        Assert.assertThrows(IllegalStateException.class, () -> ((SequenceProcessorManager)manager).next());
        Assert.assertEquals((long)0L, (long)closed.get());
    }

    private static class NilFrameProcessor
    implements FrameProcessor<Unit> {
        private NilFrameProcessor() {
        }

        public List<ReadableFrameChannel> inputChannels() {
            return Collections.emptyList();
        }

        public List<WritableFrameChannel> outputChannels() {
            return Collections.emptyList();
        }

        public ReturnOrAwait<Unit> runIncrementally(IntSet readableInputs) {
            throw new UnsupportedOperationException();
        }

        public void cleanup() {
        }
    }
}

