/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.druid.query.extraction.UpperExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class FrameStorageAdapterTest {

    @RunWith(value=Parameterized.class)
    public static class CursorTests
    extends InitializedNullHandlingTest {
        private static final int VECTOR_SIZE = 7;
        private final FrameType frameType;
        @Nullable
        private final Filter filter;
        private final Interval interval;
        private final VirtualColumns virtualColumns;
        private final boolean descending;
        private StorageAdapter queryableAdapter;
        private FrameSegment frameSegment;
        private StorageAdapter frameAdapter;

        public CursorTests(FrameType frameType, @Nullable DimFilter filter, Interval interval, VirtualColumns virtualColumns, boolean descending) {
            this.frameType = frameType;
            this.filter = Filters.toFilter((DimFilter)filter);
            this.interval = interval;
            this.virtualColumns = virtualColumns;
            this.descending = descending;
        }

        @Parameterized.Parameters(name="frameType = {0}, filter = {1}, interval = {2}, virtualColumns = {3}, descending = {4}")
        public static Iterable<Object[]> constructorFeeder() {
            ArrayList<Object[]> constructors = new ArrayList<Object[]>();
            List<Interval> intervals = Arrays.asList(TestIndex.getMMappedTestIndex().getDataInterval(), Intervals.ETERNITY, Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-02T00:00:00.000Z"), Intervals.of((String)"3001/3002"));
            ArrayList<Pair> filtersAndVirtualColumns = new ArrayList<Pair>();
            filtersAndVirtualColumns.add(Pair.of(null, (Object)VirtualColumns.EMPTY));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("quality", "automotive", null), (Object)VirtualColumns.EMPTY));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("expr", "1401", null), (Object)VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "qualityLong + 1", ColumnType.LONG, ExprMacroTable.nil())))));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("qualityLong", "1400", null), (Object)VirtualColumns.EMPTY));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("quality", "automotive", (ExtractionFn)new UpperExtractionFn(null)), (Object)VirtualColumns.EMPTY));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("__time", "Friday", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false)), (Object)VirtualColumns.EMPTY));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("__time", "Friday", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false)), (Object)VirtualColumns.EMPTY));
            for (FrameType frameType : FrameType.values()) {
                for (Pair filterVirtualColumnsPair : filtersAndVirtualColumns) {
                    for (Interval interval : intervals) {
                        for (boolean descending : Arrays.asList(false, true)) {
                            constructors.add(new Object[]{frameType, filterVirtualColumnsPair.lhs, interval, filterVirtualColumnsPair.rhs, descending});
                        }
                    }
                }
            }
            return constructors;
        }

        @Before
        public void setUp() {
            this.queryableAdapter = new QueryableIndexStorageAdapter(TestIndex.getMMappedTestIndex());
            this.frameSegment = FrameTestUtil.adapterToFrameSegment(this.queryableAdapter, this.frameType);
            this.frameAdapter = this.frameSegment.asStorageAdapter();
        }

        @After
        public void tearDown() {
            if (this.frameSegment != null) {
                this.frameSegment.close();
            }
        }

        @Test
        public void test_makeCursors() {
            this.assertCursorsMatch(adapter -> adapter.makeCursors(this.filter, this.interval, this.virtualColumns, Granularities.ALL, this.descending, null));
        }

        @Test
        public void test_makeVectorCursor() {
            Assume.assumeTrue((boolean)this.frameAdapter.canVectorize(this.filter, this.virtualColumns, this.descending));
            this.assertVectorCursorsMatch(adapter -> adapter.makeVectorCursor(this.filter, this.interval, this.virtualColumns, this.descending, 7, null));
        }

        private void assertCursorsMatch(Function<StorageAdapter, Sequence<Cursor>> call) {
            RowSignature signature = this.frameAdapter.getRowSignature();
            Sequence queryableRows = call.apply(this.queryableAdapter).flatMap(cursor -> FrameTestUtil.readRowsFromCursor(cursor, signature));
            Sequence frameRows = call.apply(this.frameAdapter).flatMap(cursor -> FrameTestUtil.readRowsFromCursor(CursorTests.advanceAndReset(cursor), signature));
            FrameTestUtil.assertRowsEqual((Sequence<List<Object>>)queryableRows, (Sequence<List<Object>>)frameRows);
        }

        private void assertVectorCursorsMatch(Function<StorageAdapter, VectorCursor> call) {
            RowSignature signature = this.frameAdapter.getRowSignature();
            Sequence<List<Object>> queryableRows = FrameTestUtil.readRowsFromVectorCursor(call.apply(this.queryableAdapter), signature);
            Sequence<List<Object>> frameRows = FrameTestUtil.readRowsFromVectorCursor(CursorTests.advanceAndReset(call.apply(this.frameAdapter)), signature);
            FrameTestUtil.assertRowsEqual(queryableRows, frameRows);
        }

        private static Cursor advanceAndReset(Cursor cursor) {
            for (int i = 0; i < 3 && !cursor.isDone(); ++i) {
                cursor.advance();
            }
            cursor.reset();
            return cursor;
        }

        private static VectorCursor advanceAndReset(VectorCursor cursor) {
            for (int i = 0; i < 3 && !cursor.isDone(); ++i) {
                cursor.advance();
            }
            cursor.reset();
            return cursor;
        }
    }

    @RunWith(value=Parameterized.class)
    public static class BasicTests
    extends InitializedNullHandlingTest {
        private final FrameType frameType;
        private StorageAdapter queryableAdapter;
        private FrameSegment frameSegment;
        private StorageAdapter frameAdapter;

        public BasicTests(FrameType frameType) {
            this.frameType = frameType;
        }

        @Parameterized.Parameters(name="frameType = {0}")
        public static Iterable<Object[]> constructorFeeder() {
            ArrayList<Object[]> constructors = new ArrayList<Object[]>();
            for (FrameType frameType : FrameType.values()) {
                constructors.add(new Object[]{frameType});
            }
            return constructors;
        }

        @Before
        public void setUp() {
            this.queryableAdapter = new QueryableIndexStorageAdapter(TestIndex.getMMappedTestIndex());
            this.frameSegment = FrameTestUtil.adapterToFrameSegment(this.queryableAdapter, this.frameType);
            this.frameAdapter = this.frameSegment.asStorageAdapter();
        }

        @After
        public void tearDown() {
            if (this.frameSegment != null) {
                this.frameSegment.close();
            }
        }

        @Test
        public void test_getInterval() {
            Assert.assertEquals((Object)this.queryableAdapter.getInterval(), (Object)this.frameAdapter.getInterval());
        }

        @Test
        public void test_getRowSignature() {
            Assert.assertEquals((Object)this.queryableAdapter.getRowSignature(), (Object)this.frameAdapter.getRowSignature());
        }

        @Test
        public void test_getAvailableDimensions() {
            Assert.assertEquals((Object)this.queryableAdapter.getRowSignature().getColumnNames(), (Object)ImmutableList.copyOf((Iterable)this.frameAdapter.getAvailableDimensions()));
        }

        @Test
        public void test_getAvailableMetrics() {
            Assert.assertEquals(Collections.emptyList(), (Object)this.frameAdapter.getAvailableMetrics());
        }

        @Test
        public void test_getDimensionCardinality_knownColumns() {
            for (String columnName : this.frameAdapter.getRowSignature().getColumnNames()) {
                Assert.assertEquals((String)columnName, (long)-1L, (long)this.frameAdapter.getDimensionCardinality(columnName));
            }
        }

        @Test
        public void test_getDimensionCardinality_unknownColumn() {
            Assert.assertEquals((long)-1L, (long)this.frameAdapter.getDimensionCardinality("nonexistent"));
        }

        @Test
        public void test_getColumnCapabilities_typeOfKnownColumns() {
            for (String columnName : this.frameAdapter.getRowSignature().getColumnNames()) {
                ColumnCapabilities expectedCapabilities = this.queryableAdapter.getColumnCapabilities(columnName);
                ColumnCapabilities actualCapabilities = this.frameAdapter.getColumnCapabilities(columnName);
                Assert.assertEquals((String)StringUtils.format((String)"column [%s] type", (Object[])new Object[]{columnName}), (Object)expectedCapabilities.toColumnType(), (Object)actualCapabilities.toColumnType());
                if (this.frameType == FrameType.COLUMNAR) {
                    Assert.assertEquals((String)StringUtils.format((String)"column [%s] hasMultipleValues", (Object[])new Object[]{columnName}), (Object)expectedCapabilities.hasMultipleValues(), (Object)actualCapabilities.hasMultipleValues());
                    continue;
                }
                Assert.assertEquals((String)StringUtils.format((String)"column [%s] hasMultipleValues", (Object[])new Object[]{columnName}), (Object)(expectedCapabilities.getType() == ValueType.STRING ? ColumnCapabilities.Capable.UNKNOWN : ColumnCapabilities.Capable.FALSE), (Object)actualCapabilities.hasMultipleValues());
            }
        }

        @Test
        public void test_getColumnCapabilities_unknownColumn() {
            Assert.assertNull((Object)this.frameAdapter.getColumnCapabilities("nonexistent"));
        }

        @Test
        public void test_getMinTime() {
            Assert.assertEquals((Object)this.queryableAdapter.getInterval().getStart(), (Object)this.frameAdapter.getMinTime());
        }

        @Test
        public void test_getMaxTime() {
            Assert.assertEquals((Object)this.queryableAdapter.getInterval().getEnd().minus(1L), (Object)this.frameAdapter.getMaxTime());
        }

        @Test
        public void test_getNumRows() {
            Assert.assertEquals((long)this.queryableAdapter.getNumRows(), (long)this.frameAdapter.getNumRows());
        }

        @Test
        public void test_getMetadata() {
            Assert.assertNull((Object)this.frameAdapter.getMetadata());
        }
    }
}

