/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.testutil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.allocation.SingleMemoryAllocatorFactory;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class FrameSequenceBuilder {
    private final StorageAdapter adapter;
    private FrameType frameType = null;
    private MemoryAllocator allocator = HeapMemoryAllocator.unlimited();
    private List<KeyColumn> keyColumns = new ArrayList<KeyColumn>();
    private int maxRowsPerFrame = Integer.MAX_VALUE;
    private boolean populateRowNumber = false;

    private FrameSequenceBuilder(StorageAdapter adapter) {
        this.adapter = adapter;
    }

    public static FrameSequenceBuilder fromAdapter(StorageAdapter adapter) {
        return new FrameSequenceBuilder(adapter);
    }

    public FrameSequenceBuilder frameType(FrameType frameType) {
        this.frameType = frameType;
        return this;
    }

    public FrameSequenceBuilder allocator(MemoryAllocator allocator) {
        this.allocator = allocator;
        return this;
    }

    public FrameSequenceBuilder sortBy(List<KeyColumn> sortBy) {
        this.keyColumns = sortBy;
        return this;
    }

    public FrameSequenceBuilder maxRowsPerFrame(int maxRowsPerFrame) {
        this.maxRowsPerFrame = maxRowsPerFrame;
        return this;
    }

    public FrameSequenceBuilder populateRowNumber() {
        this.populateRowNumber = true;
        return this;
    }

    public RowSignature signature() {
        RowSignature baseSignature = this.populateRowNumber ? RowSignature.builder().addAll(this.adapter.getRowSignature()).add("__row_number", ColumnType.LONG).build() : this.adapter.getRowSignature();
        return FrameWriters.sortableSignature((RowSignature)baseSignature, this.keyColumns);
    }

    public Sequence<Frame> frames() {
        final FrameWriterFactory frameWriterFactory = FrameWriters.makeFrameWriterFactory((FrameType)this.frameType, (MemoryAllocatorFactory)new SingleMemoryAllocatorFactory(this.allocator), (RowSignature)this.signature(), this.keyColumns);
        Sequence<Cursor> cursors = FrameTestUtil.makeCursorsForAdapter(this.adapter, this.populateRowNumber);
        return cursors.flatMap(cursor -> new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Frame, Iterator<Frame>>(){

            public Iterator<Frame> make() {
                final ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
                return new Iterator<Frame>(){

                    @Override
                    public boolean hasNext() {
                        return !cursor.isDone();
                    }

                    @Override
                    public Frame next() {
                        if (cursor.isDone()) {
                            throw new NoSuchElementException();
                        }
                        try (FrameWriter writer = frameWriterFactory.newFrameWriter(columnSelectorFactory);){
                            while (!cursor.isDone()) {
                                if (!writer.addSelection()) {
                                    if (writer.getNumRows() == 0) {
                                        throw new FrameRowTooLargeException(FrameSequenceBuilder.this.allocator.capacity());
                                    }
                                    Frame frame = this.makeFrame(writer);
                                    return frame;
                                }
                                cursor.advance();
                                if (writer.getNumRows() < FrameSequenceBuilder.this.maxRowsPerFrame) continue;
                                Frame frame = this.makeFrame(writer);
                                return frame;
                            }
                            Frame frame = this.makeFrame(writer);
                            return frame;
                        }
                    }

                    private Frame makeFrame(FrameWriter writer) {
                        return Frame.wrap((byte[])writer.toByteArray());
                    }
                };
            }

            public void cleanup(Iterator<Frame> iterFromMake) {
            }
        }));
    }
}

