/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.testutil;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.channel.FrameChannelSequence;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.segment.FrameStorageAdapter;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.frame.testutil.RowNumberUpdatingCursor;
import org.apache.druid.frame.testutil.RowReadingVectorColumnProcessorFactory;
import org.apache.druid.frame.util.SettableLongVirtualColumn;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;
import org.junit.Assert;

public class FrameTestUtil {
    public static final String ROW_NUMBER_COLUMN = "__row_number";

    private FrameTestUtil() {
    }

    public static File writeFrameFile(Sequence<Frame> frames, File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             FrameFileWriter writer = FrameFileWriter.open((WritableByteChannel)Channels.newChannel(fos), null, (ByteTracker)ByteTracker.unboundedTracker());){
            frames.forEach(frame -> {
                try {
                    writer.writeFrame(frame, -1);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return file;
    }

    public static File writeFrameFileWithPartitions(Sequence<IntObjectPair<Frame>> framesWithPartitions, File file) throws IOException {
        try (FrameFileWriter writer = FrameFileWriter.open((WritableByteChannel)Channels.newChannel(new FileOutputStream(file)), null, (ByteTracker)ByteTracker.unboundedTracker());){
            framesWithPartitions.forEach(frameWithPartition -> {
                try {
                    writer.writeFrame((Frame)frameWithPartition.right(), frameWithPartition.leftInt());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return file;
    }

    public static void assertRowsEqual(Sequence<List<Object>> expected, Sequence<List<Object>> actual) {
        List expectedRows = expected.toList();
        List actualRows = actual.toList();
        Assert.assertEquals((String)"number of rows", (long)expectedRows.size(), (long)actualRows.size());
        for (int i = 0; i < expectedRows.size(); ++i) {
            FrameTestUtil.assertRowEqual("row #" + i, (List)expectedRows.get(i), (List)actualRows.get(i));
        }
    }

    public static void assertRowEqual(List<Object> expected, List<Object> actual) {
        FrameTestUtil.assertRowEqual(null, expected, actual);
    }

    public static void assertRowEqual(String message, List<Object> expected, List<Object> actual) {
        boolean ok;
        if (expected.size() == actual.size()) {
            ok = true;
            for (int i = 0; i < expected.size(); ++i) {
                Object actualValue;
                Object expectedValue = expected.get(i);
                if (Objects.deepEquals(expectedValue, actualValue = actual.get(i))) continue;
                ok = false;
                break;
            }
        } else {
            ok = false;
        }
        if (!ok) {
            Assert.assertEquals((String)message, (Object)Arrays.deepToString(expected.toArray()), (Object)Arrays.deepToString(actual.toArray()));
            Assert.fail((String)message);
        }
    }

    public static Frame adapterToFrame(StorageAdapter adapter, FrameType frameType) {
        return (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromAdapter(adapter).allocator((MemoryAllocator)HeapMemoryAllocator.unlimited()).frameType(frameType).frames().toList());
    }

    public static FrameSegment adapterToFrameSegment(StorageAdapter adapter, FrameType frameType) {
        return new FrameSegment(FrameTestUtil.adapterToFrame(adapter, frameType), FrameReader.create((RowSignature)adapter.getRowSignature()), SegmentId.of((String)"TestFrame", (Interval)adapter.getInterval(), (String)"0", (int)0));
    }

    public static FrameSegment adapterToFrameSegment(StorageAdapter adapter, FrameType frameType, SegmentId segmentId) {
        return new FrameSegment(FrameTestUtil.adapterToFrame(adapter, frameType), FrameReader.create((RowSignature)adapter.getRowSignature()), segmentId);
    }

    public static Sequence<List<Object>> readRowsFromFrameChannel(ReadableFrameChannel channel, FrameReader frameReader) {
        return new FrameChannelSequence(channel).flatMap(frame -> new FrameStorageAdapter(frame, frameReader, Intervals.ETERNITY).makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null).flatMap(cursor -> FrameTestUtil.readRowsFromCursor(cursor, frameReader.signature())));
    }

    public static Sequence<List<Object>> readRowsFromAdapter(StorageAdapter adapter, @Nullable RowSignature signature, boolean populateRowNumber) {
        RowSignature signatureToUse = signature == null ? adapter.getRowSignature() : signature;
        return FrameTestUtil.makeCursorsForAdapter(adapter, populateRowNumber).flatMap(cursor -> FrameTestUtil.readRowsFromCursor(cursor, signatureToUse));
    }

    public static Sequence<Cursor> makeCursorsForAdapter(StorageAdapter adapter, boolean populateRowNumber) {
        VirtualColumns virtualColumns;
        SettableLongVirtualColumn rowNumberVirtualColumn;
        if (populateRowNumber) {
            rowNumberVirtualColumn = new SettableLongVirtualColumn(ROW_NUMBER_COLUMN);
            virtualColumns = VirtualColumns.create(Collections.singletonList(rowNumberVirtualColumn));
        } else {
            rowNumberVirtualColumn = null;
            virtualColumns = VirtualColumns.EMPTY;
        }
        return adapter.makeCursors(null, Intervals.ETERNITY, virtualColumns, Granularities.ALL, false, null).map(cursor -> {
            if (populateRowNumber) {
                return new RowNumberUpdatingCursor((Cursor)cursor, rowNumberVirtualColumn);
            }
            return cursor;
        });
    }

    public static Sequence<List<Object>> readRowsFromCursor(Cursor cursor, RowSignature signature) {
        ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
        ArrayList<Supplier<Object>> columnReaders = new ArrayList<Supplier<Object>>();
        for (int i = 0; i < signature.size(); ++i) {
            ColumnValueSelector selector;
            String columnName = signature.getColumnName(i);
            Optional columnType = signature.getColumnType(i);
            if (columnType.isPresent() && ((ColumnType)columnType.get()).is((TypeDescriptor)ValueType.STRING)) {
                selector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)columnName));
                columnReaders.add(FrameTestUtil.dimensionSelectorReader((DimensionSelector)selector));
                continue;
            }
            selector = columnSelectorFactory.makeColumnValueSelector(columnName);
            columnReaders.add(() -> ((ColumnValueSelector)selector).getObject());
        }
        ArrayList retVal = new ArrayList();
        while (!cursor.isDone()) {
            List o = columnReaders.stream().map(Supplier::get).collect(Collectors.toList());
            retVal.add(o);
            cursor.advance();
        }
        return Sequences.simple(retVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence<List<Object>> readRowsFromVectorCursor(VectorCursor cursor, RowSignature signature) {
        try {
            VectorColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            ArrayList<Supplier> columnReaders = new ArrayList<Supplier>();
            for (int i = 0; i < signature.size(); ++i) {
                String columnName = signature.getColumnName(i);
                Supplier columnReader = (Supplier)ColumnProcessors.makeVectorProcessor((String)columnName, (VectorColumnProcessorFactory)RowReadingVectorColumnProcessorFactory.INSTANCE, (VectorColumnSelectorFactory)columnSelectorFactory);
                columnReaders.add(columnReader);
            }
            ArrayList retVal = new ArrayList();
            while (!cursor.isDone()) {
                int vectorSize = cursor.getCurrentVectorSize();
                List columns = columnReaders.stream().map(Supplier::get).collect(Collectors.toList());
                for (int i = 0; i < vectorSize; ++i) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    for (Object[] column : columns) {
                        row.add(column[i]);
                    }
                    retVal.add(row);
                }
                cursor.advance();
            }
            Sequence sequence = Sequences.simple(retVal);
            return sequence;
        }
        finally {
            cursor.close();
        }
    }

    private static Supplier<Object> dimensionSelectorReader(DimensionSelector selector) {
        return () -> {
            IndexedInts row = selector.getRow();
            int sz = row.size();
            if (sz == 1) {
                return selector.lookupName(row.get(0));
            }
            ArrayList<String> retVal = new ArrayList<String>(sz);
            for (int i = 0; i < sz; ++i) {
                retVal.add(selector.lookupName(row.get(i)));
            }
            return retVal;
        };
    }
}

