/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.allocation.SingleMemoryAllocatorFactory;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.KeyTestUtils;
import org.apache.druid.frame.key.RowKeyComparator;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.segment.FrameStorageAdapter;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriterTestData;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FrameWriterTest
extends InitializedNullHandlingTest {
    private static final int DEFAULT_ALLOCATOR_CAPACITY = 1000000;
    @Nullable
    private final FrameType inputFrameType;
    private final FrameType outputFrameType;
    private final KeyOrder sortedness;
    private MemoryAllocator allocator;
    @Nullable
    private Consumer<ColumnCapabilitiesImpl> capabilitiesAdjustFn;

    public FrameWriterTest(@Nullable FrameType inputFrameType, FrameType outputFrameType, KeyOrder sortedness) {
        this.inputFrameType = inputFrameType;
        this.outputFrameType = outputFrameType;
        this.sortedness = sortedness;
        this.allocator = ArenaMemoryAllocator.createOnHeap((int)1000000);
    }

    @Parameterized.Parameters(name="inputFrameType = {0}, outputFrameType = {1}, sorted = {2}")
    public static Iterable<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        Iterable inputFrameTypes = Iterables.concat(Collections.singletonList(null), Arrays.asList(FrameType.values()));
        for (FrameType inputFrameType : inputFrameTypes) {
            for (FrameType outputFrameType : FrameType.values()) {
                for (KeyOrder sortedness : KeyOrder.values()) {
                    if (sortedness != KeyOrder.NONE && outputFrameType != FrameType.ROW_BASED) continue;
                    constructors.add(new Object[]{inputFrameType, outputFrameType, sortedness});
                }
            }
        }
        return constructors;
    }

    @BeforeClass
    public static void setUpClass() {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
    }

    @Test
    public void test_string_multiValueTrue() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.TRUE);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE);
    }

    @Test
    public void test_string_multiValueFalse() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.FALSE);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE);
    }

    @Test
    public void test_string_multiValueUnknown() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.UNKNOWN);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE);
    }

    @Test
    public void test_singleValueWithEmpty_multiValueTrue() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.TRUE);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_MULTI_VALUE);
    }

    @Test
    public void test_singleValueWithEmpty_multiValueFalse() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.FALSE);
        FrameWriterTestData.Dataset<Object> expectedReadDataset = this.outputFrameType == FrameType.COLUMNAR ? FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE : FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE_WITH_EMPTY;
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE_WITH_EMPTY, expectedReadDataset);
    }

    @Test
    public void test_singleValueWithEmpty_multiValueUnknown() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.UNKNOWN);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_SINGLE_VALUE_WITH_EMPTY);
    }

    @Test
    public void test_multiValueString_multiValueTrue() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.TRUE);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_MULTI_VALUE);
    }

    @Test
    public void test_multiValueString_multiValueFalse() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.FALSE);
        if (this.outputFrameType == FrameType.COLUMNAR) {
            IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.testWithDataset(FrameWriterTestData.TEST_STRINGS_MULTI_VALUE));
            MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Encountered unexpected multi-value row")));
        } else {
            this.testWithDataset(FrameWriterTestData.TEST_STRINGS_MULTI_VALUE);
        }
    }

    @Test
    public void test_multiValueString_multiValueUnknown() {
        this.capabilitiesAdjustFn = capabilities -> capabilities.setHasMultipleValues(ColumnCapabilities.Capable.UNKNOWN);
        this.testWithDataset(FrameWriterTestData.TEST_STRINGS_MULTI_VALUE);
    }

    @Test
    public void test_arrayString() {
        this.testWithDataset(FrameWriterTestData.TEST_ARRAYS_STRING);
    }

    @Test
    public void test_long() {
        this.testWithDataset(FrameWriterTestData.TEST_LONGS);
    }

    @Test
    public void test_arrayLong() {
        Assume.assumeFalse((this.inputFrameType == FrameType.COLUMNAR || this.outputFrameType == FrameType.COLUMNAR ? 1 : 0) != 0);
        this.testWithDataset(FrameWriterTestData.TEST_ARRAYS_LONG);
    }

    @Test
    public void test_arrayFloat() {
        Assume.assumeFalse((this.inputFrameType == FrameType.COLUMNAR || this.outputFrameType == FrameType.COLUMNAR ? 1 : 0) != 0);
        this.testWithDataset(FrameWriterTestData.TEST_ARRAYS_FLOAT);
    }

    @Test
    public void test_arrayDouble() {
        Assume.assumeFalse((this.inputFrameType == FrameType.COLUMNAR || this.outputFrameType == FrameType.COLUMNAR ? 1 : 0) != 0);
        this.testWithDataset(FrameWriterTestData.TEST_ARRAYS_DOUBLE);
    }

    @Test
    public void test_float() {
        this.testWithDataset(FrameWriterTestData.TEST_FLOATS);
    }

    @Test
    public void test_double() {
        this.testWithDataset(FrameWriterTestData.TEST_DOUBLES);
    }

    @Test
    public void test_complex() {
        Assume.assumeThat((Object)this.sortedness, (Matcher)CoreMatchers.is((Object)KeyOrder.NONE));
        this.testWithDataset(FrameWriterTestData.TEST_COMPLEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_readNullsInDefaultValueMode() {
        Pair<Frame, Integer> writeResult;
        RowSignature signature = RowSignature.builder().add("l1", ColumnType.LONG).add("f1", ColumnType.FLOAT).add("d1", ColumnType.DOUBLE).add("s1", ColumnType.STRING).add("l2", ColumnType.LONG).add("f2", ColumnType.FLOAT).add("d2", ColumnType.DOUBLE).add("s2", ColumnType.STRING).build();
        try {
            NullHandling.initializeForTestsWithValues((Boolean)false, null);
            Sequence rowSequence = Sequences.simple((Iterable)ImmutableList.of(Arrays.asList(null, null, null, null, 0L, Float.valueOf(0.0f), 0.0, "")));
            writeResult = this.writeFrame((Sequence<List<Object>>)rowSequence, signature, signature.getColumnNames());
        }
        finally {
            NullHandling.initializeForTests();
        }
        Assert.assertEquals((long)1L, (long)((Integer)writeResult.rhs).intValue());
        try {
            NullHandling.initializeForTestsWithValues((Boolean)true, null);
            this.verifyFrame((Sequence<List<Object>>)Sequences.simple((Iterable)ImmutableList.of(Arrays.asList(null, null, null, null, 0L, Float.valueOf(0.0f), 0.0, null))), (Frame)writeResult.lhs, signature);
        }
        finally {
            NullHandling.initializeForTests();
        }
    }

    @Test
    public void test_typePairs() {
        for (FrameWriterTestData.Dataset<?> dataset1 : FrameWriterTestData.DATASETS) {
            for (FrameWriterTestData.Dataset<?> dataset2 : FrameWriterTestData.DATASETS) {
                if ((dataset1.getType().isArray() && dataset1.getType().getElementType().isNumeric() || dataset2.getType().isArray() && dataset2.getType().getElementType().isNumeric()) && (this.inputFrameType == FrameType.COLUMNAR || this.outputFrameType == FrameType.COLUMNAR)) continue;
                RowSignature signature = FrameWriterTest.makeSignature(Arrays.asList(dataset1, dataset2));
                Sequence<List<Object>> rowSequence = FrameWriterTest.unsortAndMakeRows(Arrays.asList(dataset1, dataset2));
                ArrayList<String> sortColumns = new ArrayList<String>();
                if (!dataset1.getType().is((TypeDescriptor)ValueType.COMPLEX)) {
                    sortColumns.add(signature.getColumnName(0));
                    if (!dataset2.getType().is((TypeDescriptor)ValueType.COMPLEX)) {
                        sortColumns.add(signature.getColumnName(1));
                    }
                }
                try {
                    Pair<Frame, Integer> writeResult = this.writeFrame(rowSequence, signature, sortColumns);
                    Assert.assertEquals((long)rowSequence.toList().size(), (long)((Integer)writeResult.rhs).intValue());
                    this.verifyFrame(this.sortIfNeeded(rowSequence, signature, sortColumns), (Frame)writeResult.lhs, signature);
                }
                catch (AssertionError e) {
                    throw new AssertionError(StringUtils.format((String)"Assert failed in test (%s, %s)", (Object[])new Object[]{dataset1.getType(), dataset2.getType()}), (Throwable)((Object)e));
                }
                catch (Throwable e) {
                    throw new RE(e, "Exception in test (%s, %s)", new Object[]{dataset1.getType(), dataset2.getType()});
                }
            }
        }
    }

    @Test
    public void test_insufficientWriteCapacity() {
        Pair<Frame, Integer> writeResult;
        Assume.assumeFalse((this.inputFrameType == FrameType.COLUMNAR || this.outputFrameType == FrameType.COLUMNAR ? 1 : 0) != 0);
        RowSignature signature = FrameWriterTest.makeSignature(FrameWriterTestData.DATASETS);
        Sequence<List<Object>> rowSequence = FrameWriterTest.unsortAndMakeRows(FrameWriterTestData.DATASETS);
        int totalRows = rowSequence.toList().size();
        ArrayList<String> sortColumns = new ArrayList<String>();
        for (int i = 0; i < signature.size() && !((ColumnType)signature.getColumnType(i).get()).is((TypeDescriptor)ValueType.COMPLEX); ++i) {
            sortColumns.add(signature.getColumnName(i));
        }
        ByteBuffer allocatorMemory = ByteBuffer.wrap(new byte[1000000]);
        boolean didWritePartial = false;
        int allocatorSize = 0;
        do {
            allocatorMemory.limit(allocatorSize);
            allocatorMemory.position(0);
            this.allocator = ArenaMemoryAllocator.create((ByteBuffer)allocatorMemory);
            try {
                writeResult = this.writeFrame(rowSequence, signature, sortColumns);
                int rowsWritten = (Integer)writeResult.rhs;
                if ((Integer)writeResult.rhs > 0 && (Integer)writeResult.rhs < totalRows) {
                    didWritePartial = true;
                    this.verifyFrame(this.sortIfNeeded((Sequence<List<Object>>)rowSequence.limit((long)rowsWritten), signature, sortColumns), (Frame)writeResult.lhs, signature);
                }
            }
            catch (Throwable e) {
                throw new RE(e, "Exception while writing with allocatorSize = %s", new Object[]{allocatorSize});
            }
            ++allocatorSize;
        } while ((Integer)writeResult.rhs != totalRows);
        this.verifyFrame(this.sortIfNeeded(rowSequence, signature, sortColumns), (Frame)writeResult.lhs, signature);
        Assert.assertTrue((String)"did write a partial frame", (boolean)didWritePartial);
    }

    private void verifyFrame(Sequence<List<Object>> expectedRows, Frame frame, RowSignature signature) {
        FrameStorageAdapter frameAdapter = new FrameStorageAdapter(frame, FrameReader.create((RowSignature)signature), Intervals.ETERNITY);
        FrameTestUtil.assertRowsEqual(expectedRows, FrameTestUtil.readRowsFromAdapter((StorageAdapter)frameAdapter, signature, false));
    }

    private Sequence<List<Object>> sortIfNeeded(Sequence<List<Object>> rows, RowSignature signature, List<String> sortColumnNames) {
        List<KeyColumn> keyColumns = this.computeSortColumns(sortColumnNames);
        if (keyColumns.isEmpty()) {
            return rows;
        }
        RowSignature keySignature = KeyTestUtils.createKeySignature(keyColumns, (ColumnInspector)signature);
        RowKeyComparator keyComparator = RowKeyComparator.create(keyColumns);
        return Sequences.sort(rows, Comparator.comparing(row -> KeyTestUtils.createKey(keySignature, row.toArray()), keyComparator));
    }

    private Pair<Frame, Integer> writeFrame(Sequence<List<Object>> rows, RowSignature signature, List<String> sortColumns) {
        return FrameWriterTest.writeFrame(this.inputFrameType, this.outputFrameType, this.allocator, this.capabilitiesAdjustFn, rows, signature, this.computeSortColumns(sortColumns));
    }

    private List<KeyColumn> computeSortColumns(List<String> sortColumnNames) {
        if (this.sortedness == KeyOrder.NONE) {
            return Collections.emptyList();
        }
        return sortColumnNames.stream().map(columnName -> new KeyColumn(columnName, this.sortedness)).collect(Collectors.toList());
    }

    private <T> void testWithDataset(FrameWriterTestData.Dataset<T> dataset) {
        List<T> data = dataset.getData(KeyOrder.NONE);
        RowSignature signature = RowSignature.builder().add("x", dataset.getType()).build();
        Sequence<List<Object>> rowSequence = FrameWriterTest.rows(data);
        Pair<Frame, Integer> writeResult = this.writeFrame(rowSequence, signature, signature.getColumnNames());
        Assert.assertEquals((long)data.size(), (long)((Integer)writeResult.rhs).intValue());
        this.verifyFrame(FrameWriterTest.rows(dataset.getData(this.sortedness)), (Frame)writeResult.lhs, signature);
    }

    private <T1, T2> void testWithDataset(FrameWriterTestData.Dataset<T1> writeDataset, FrameWriterTestData.Dataset<T2> readDataset) {
        List<T1> data = writeDataset.getData(KeyOrder.NONE);
        RowSignature signature = RowSignature.builder().add("x", writeDataset.getType()).build();
        Sequence<List<Object>> rowSequence = FrameWriterTest.rows(data);
        Pair<Frame, Integer> writeResult = this.writeFrame(rowSequence, signature, signature.getColumnNames());
        Assert.assertEquals((long)data.size(), (long)((Integer)writeResult.rhs).intValue());
        this.verifyFrame(FrameWriterTest.rows(readDataset.getData(this.sortedness)), (Frame)writeResult.lhs, signature);
    }

    private static Pair<Frame, Integer> writeFrame(@Nullable FrameType inputFrameType, FrameType outputFrameType, MemoryAllocator allocator, @Nullable Consumer<ColumnCapabilitiesImpl> capabilitiesAdjustFn, Sequence<List<Object>> rows, RowSignature signature, List<KeyColumn> keyColumns) {
        RowBasedSegment inputSegment;
        if (inputFrameType == null) {
            inputSegment = new RowBasedSegment(SegmentId.dummy((String)"dummy"), rows, columnName -> {
                int columnNumber = signature.indexOf(columnName);
                return row -> columnNumber >= 0 ? row.get(columnNumber) : null;
            }, signature);
        } else {
            Frame inputFrame = (Frame)FrameWriterTest.writeFrame(null, (FrameType)inputFrameType, (MemoryAllocator)HeapMemoryAllocator.unlimited(), null, rows, (RowSignature)signature, Collections.emptyList()).lhs;
            inputSegment = new FrameSegment(inputFrame, FrameReader.create((RowSignature)signature), SegmentId.dummy((String)"xxx"));
        }
        return (Pair)inputSegment.asStorageAdapter().makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null).accumulate(null, (retVal, cursor) -> {
            int numRows = 0;
            FrameWriterFactory frameWriterFactory = FrameWriters.makeFrameWriterFactory((FrameType)outputFrameType, (MemoryAllocatorFactory)new SingleMemoryAllocatorFactory(allocator), (RowSignature)signature, (List)keyColumns);
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            if (capabilitiesAdjustFn != null) {
                columnSelectorFactory = new OverrideCapabilitiesColumnSelectorFactory(columnSelectorFactory, capabilitiesAdjustFn);
            }
            try (FrameWriter frameWriter = frameWriterFactory.newFrameWriter(columnSelectorFactory);){
                while (!cursor.isDone() && frameWriter.addSelection()) {
                    ++numRows;
                    cursor.advance();
                }
                Pair pair = Pair.of((Object)Frame.wrap((byte[])frameWriter.toByteArray()), (Object)numRows);
                return pair;
            }
        });
    }

    @Nullable
    private static Object fillerValueForType(ValueType type) {
        switch (type) {
            case LONG: {
                return NullHandling.defaultLongValue();
            }
            case FLOAT: {
                return NullHandling.defaultFloatValue();
            }
            case DOUBLE: {
                return NullHandling.defaultDoubleValue();
            }
        }
        return null;
    }

    private static RowSignature makeSignature(List<FrameWriterTestData.Dataset<?>> datasets) {
        RowSignature.Builder signatureBuilder = RowSignature.builder();
        for (int i = 0; i < datasets.size(); ++i) {
            FrameWriterTestData.Dataset<?> dataset = datasets.get(i);
            signatureBuilder.add(StringUtils.format((String)"col%03d", (Object[])new Object[]{i}), dataset.getType());
        }
        return signatureBuilder.build();
    }

    private static Sequence<List<Object>> unsortAndMakeRows(List<FrameWriterTestData.Dataset<?>> datasets) {
        ArrayList retVal = new ArrayList();
        int rowSize = datasets.size();
        List iterators = datasets.stream().map(dataset -> dataset.getData(KeyOrder.NONE).iterator()).collect(Collectors.toList());
        while (iterators.stream().anyMatch(Iterator::hasNext)) {
            ArrayList<Object> row = new ArrayList<Object>(rowSize);
            for (int i = 0; i < rowSize; ++i) {
                if (((Iterator)iterators.get(i)).hasNext()) {
                    row.add(((Iterator)iterators.get(i)).next());
                    continue;
                }
                row.add(FrameWriterTest.fillerValueForType((ValueType)datasets.get(i).getType().getType()));
            }
            retVal.add(row);
        }
        return Sequences.simple(retVal);
    }

    private static Sequence<List<Object>> rows(List<?> vals) {
        ArrayList retVal = new ArrayList();
        for (Object val : vals) {
            retVal.add(Collections.singletonList(val));
        }
        return Sequences.simple(retVal);
    }

    private static class OverrideCapabilitiesColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final ColumnSelectorFactory delegate;
        private final Consumer<ColumnCapabilitiesImpl> fn;

        public OverrideCapabilitiesColumnSelectorFactory(ColumnSelectorFactory delegate, Consumer<ColumnCapabilitiesImpl> fn) {
            this.delegate = delegate;
            this.fn = fn;
        }

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return this.delegate.makeDimensionSelector(dimensionSpec);
        }

        public ColumnValueSelector makeColumnValueSelector(String columnName) {
            return this.delegate.makeColumnValueSelector(columnName);
        }

        @Nullable
        public ColumnCapabilities getColumnCapabilities(String column) {
            ColumnCapabilities capabilities = this.delegate.getColumnCapabilities(column);
            if (capabilities == null) {
                return null;
            }
            ColumnCapabilitiesImpl retVal = ColumnCapabilitiesImpl.copyOf((ColumnCapabilities)capabilities);
            this.fn.accept(retVal);
            return retVal;
        }

        @Nullable
        public RowIdSupplier getRowIdSupplier() {
            return this.delegate.getRowIdSupplier();
        }
    }
}

