/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.segment.column.ColumnType;

public class FrameWriterTestData {
    public static final Dataset<String> TEST_STRINGS_SINGLE_VALUE = new Dataset<String>(ColumnType.STRING, Arrays.asList(null, NullHandling.emptyToNullIfNeeded((String)""), "brown", "dog", "fox", "jumps", "lazy", "over", "quick", "the", "the", "thee", "\ud83d\ude42", "\ud83e\udd20", "\ud83e\udee5"));
    public static final Dataset<Object> TEST_STRINGS_SINGLE_VALUE_WITH_EMPTY = new Dataset<Object>(ColumnType.STRING, Arrays.asList(Collections.emptyList(), NullHandling.emptyToNullIfNeeded((String)""), "brown", "dog", "fox", "jumps", "lazy", "over", "quick", "the", "the", "thee", "\ud83d\ude42", "\ud83e\udd20", "\ud83e\udee5"));
    public static final Dataset<Object> TEST_STRINGS_MULTI_VALUE = new Dataset<Object>(ColumnType.STRING, Arrays.asList(Collections.emptyList(), null, NullHandling.emptyToNullIfNeeded((String)""), "foo", Arrays.asList("lazy", "dog"), "qux", Arrays.asList("the", "quick", "brown"), Arrays.asList("the", "quick", "brown", null), Arrays.asList("the", "quick", "brown", NullHandling.emptyToNullIfNeeded((String)"")), Arrays.asList("the", "quick", "brown", "fox"), Arrays.asList("the", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"), Arrays.asList("the", "quick", "brown", "null"), Arrays.asList("thee", "quick", "brown"), "\ud83d\ude42", Arrays.asList("\ud83d\ude42", "\ud83e\udee5"), "\ud83e\udd20"));
    public static final Dataset<Object> TEST_ARRAYS_STRING = new Dataset<Object>(ColumnType.STRING_ARRAY, Arrays.asList(null, ObjectArrays.EMPTY_ARRAY, new Object[]{null}, new Object[]{NullHandling.emptyToNullIfNeeded((String)"")}, new Object[]{"dog"}, new Object[]{"lazy"}, new Object[]{"the", "quick", "brown"}, new Object[]{"the", "quick", "brown", null}, new Object[]{"the", "quick", "brown", NullHandling.emptyToNullIfNeeded((String)"")}, new Object[]{"the", "quick", "brown", "fox"}, new Object[]{"the", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"}, new Object[]{"the", "quick", "brown", "null"}, new Object[]{"\ud83d\ude42"}, new Object[]{"\ud83d\ude42", "\ud83e\udee5"}));
    public static final Dataset<Long> TEST_LONGS = new Dataset(ColumnType.LONG, Stream.of(NullHandling.defaultLongValue(), 0L, -1L, 1L, Long.MAX_VALUE, Long.MIN_VALUE, 101L, -101L, 3L, -2L, 2L, 1L, -1L, -3L).sorted((Comparator<Long>)Comparators.naturalNullsFirst()).collect(Collectors.toList()));
    public static final Dataset<Object> TEST_ARRAYS_LONG = new Dataset<Object>(ColumnType.LONG_ARRAY, Arrays.asList(null, ObjectArrays.EMPTY_ARRAY, new Object[]{null}, new Object[]{null, 6L, null, 5L, null}, new Object[]{null, 6L, null, 5L, NullHandling.defaultLongValue()}, new Object[]{null, 6L, null, 5L, 0L, -1L}, new Object[]{null, 6L, null, 5L, 0L, -1L, Long.MIN_VALUE}, new Object[]{null, 6L, null, 5L, 0L, -1L, Long.MAX_VALUE}, new Object[]{5L}, new Object[]{5L, 6L}, new Object[]{5L, 6L, null}, new Object[]{Long.MAX_VALUE, Long.MIN_VALUE}));
    public static final Dataset<Float> TEST_FLOATS = new Dataset(ColumnType.FLOAT, Stream.of(Float.valueOf(0.0f), Float.valueOf(-0.0f), NullHandling.defaultFloatValue(), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.NaN), Float.valueOf(-101.0f), Float.valueOf(101.0f), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(0.004f), Float.valueOf(2.7E20f)).sorted((Comparator<Float>)Comparators.naturalNullsFirst()).collect(Collectors.toList()));
    public static final Dataset<Object> TEST_ARRAYS_FLOAT = new Dataset<Object>(ColumnType.FLOAT_ARRAY, Arrays.asList(null, ObjectArrays.EMPTY_ARRAY, new Object[]{null}, new Object[]{null, Float.valueOf(6.2f), null, Float.valueOf(5.1f), null}, new Object[]{null, Float.valueOf(6.2f), null, Float.valueOf(5.1f), NullHandling.defaultFloatValue()}, new Object[]{null, Float.valueOf(6.2f), null, Float.valueOf(5.7f), Float.valueOf(0.0f), Float.valueOf(-1.0f)}, new Object[]{null, Float.valueOf(6.2f), null, Float.valueOf(5.7f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(Float.MIN_VALUE)}, new Object[]{null, Float.valueOf(6.2f), null, Float.valueOf(5.7f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE)}, new Object[]{Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.MIN_VALUE)}, new Object[]{Float.valueOf(5.7f)}, new Object[]{Float.valueOf(5.7f), Float.valueOf(6.2f)}, new Object[]{Float.valueOf(5.7f), Float.valueOf(6.2f), null}, new Object[]{Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE)}, new Object[]{Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.MIN_VALUE)}));
    public static final Dataset<Double> TEST_DOUBLES = new Dataset(ColumnType.DOUBLE, Stream.of(0.0, -0.0, NullHandling.defaultDoubleValue(), -1.0E-122, 1.0E122, Double.MIN_VALUE, Double.MAX_VALUE, Double.NaN, -101.0, 101.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, -1.0E-6, 2.7E100).sorted((Comparator<Double>)Comparators.naturalNullsFirst()).collect(Collectors.toList()));
    public static final Dataset<Object> TEST_ARRAYS_DOUBLE = new Dataset<Object>(ColumnType.DOUBLE_ARRAY, Arrays.asList(null, ObjectArrays.EMPTY_ARRAY, new Object[]{null}, new Object[]{null, 6.2, null, 5.1, null}, new Object[]{null, 6.2, null, 5.1, NullHandling.defaultDoubleValue()}, new Object[]{null, 6.2, null, 5.7, 0.0, -1.0}, new Object[]{null, 6.2, null, 5.7, 0.0, -1.0, Double.MIN_VALUE}, new Object[]{null, 6.2, null, 5.7, 0.0, -1.0, Double.MAX_VALUE}, new Object[]{Double.NEGATIVE_INFINITY, Double.MIN_VALUE}, new Object[]{5.7}, new Object[]{5.7, 6.2}, new Object[]{5.7, 6.2, null}, new Object[]{Double.MAX_VALUE, Double.MIN_VALUE}, new Object[]{Double.POSITIVE_INFINITY, Double.MIN_VALUE}));
    public static final Dataset<HyperLogLogCollector> TEST_COMPLEX = new Dataset<HyperLogLogCollector>(HyperUniquesAggregatorFactory.TYPE, Arrays.asList(null, FrameWriterTestData.makeHllCollector(null), FrameWriterTestData.makeHllCollector("foo")));
    public static final List<Dataset<?>> DATASETS = ImmutableList.builder().add(TEST_FLOATS).add(TEST_DOUBLES).add(TEST_LONGS).add(TEST_STRINGS_SINGLE_VALUE).add(TEST_STRINGS_MULTI_VALUE).add(TEST_ARRAYS_STRING).add(TEST_ARRAYS_LONG).add(TEST_ARRAYS_FLOAT).add(TEST_ARRAYS_DOUBLE).add(TEST_COMPLEX).build();

    private static HyperLogLogCollector makeHllCollector(@Nullable String value) {
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        if (value != null) {
            collector.add(Hashing.murmur3_128().hashBytes(StringUtils.toUtf8((String)value)).asBytes());
        }
        return collector;
    }

    public static class Dataset<T> {
        private final ColumnType type;
        private final List<T> sortedData;

        public Dataset(ColumnType type, List<T> sortedData) {
            this.type = type;
            this.sortedData = sortedData;
        }

        public ColumnType getType() {
            return this.type;
        }

        public List<T> getData(KeyOrder sortedness) {
            switch (sortedness) {
                case ASCENDING: {
                    return Collections.unmodifiableList(this.sortedData);
                }
                case DESCENDING: {
                    return Collections.unmodifiableList(Lists.reverse(this.sortedData));
                }
                case NONE: {
                    ArrayList<T> newList = new ArrayList<T>(this.sortedData);
                    Collections.shuffle(newList, new Random(0L));
                    return newList;
                }
            }
            throw new ISE("No such sortedness [%s]", new Object[]{sortedness});
        }
    }
}

