/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Injector;
import java.util.Collections;
import java.util.Properties;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.ExtensionsLoader;
import org.apache.druid.guice.ModulesConfig;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.utils.RuntimeInfo;
import org.junit.Assert;
import org.junit.Test;

public class StartupInjectorBuilderTest {
    @Test
    public void testEmpty() {
        Injector injector = new StartupInjectorBuilder().build();
        Properties props = (Properties)injector.getInstance(Properties.class);
        Assert.assertNotNull((Object)props);
        Assert.assertTrue((boolean)props.isEmpty());
        Assert.assertNotSame((Object)props, (Object)injector.getInstance(Properties.class));
        Assert.assertNotNull((Object)injector.getInstance(RuntimeInfo.class));
        Assert.assertSame((Object)injector.getInstance(RuntimeInfo.class), (Object)injector.getInstance(RuntimeInfo.class));
        Assert.assertNotNull((Object)injector.getInstance(ExtensionsLoader.class));
        Assert.assertSame((Object)injector.getInstance(ExtensionsLoader.class), (Object)injector.getInstance(ExtensionsLoader.class));
        Assert.assertNotNull((Object)injector.getInstance(DruidSecondaryModule.class));
        Assert.assertSame((Object)injector.getInstance(DruidSecondaryModule.class), (Object)injector.getInstance(DruidSecondaryModule.class));
    }

    @Test
    public void testEmptyTestInjector() {
        Injector injector = new StartupInjectorBuilder().forTests().build();
        Properties props = (Properties)injector.getInstance(Properties.class);
        Assert.assertNotNull((Object)props);
        Assert.assertTrue((boolean)props.isEmpty());
        Assert.assertNotSame((Object)props, (Object)injector.getInstance(Properties.class));
        Assert.assertNull((Object)injector.getInstance(RuntimeInfo.class));
        Assert.assertNull((Object)injector.getInstance(ExtensionsLoader.class));
        Assert.assertNotNull((Object)injector.getInstance(DruidSecondaryModule.class));
        Assert.assertSame((Object)injector.getInstance(DruidSecondaryModule.class), (Object)injector.getInstance(DruidSecondaryModule.class));
    }

    @Test
    public void testEmptyProperties() {
        Injector injector = new StartupInjectorBuilder().withEmptyProperties().build();
        Properties props = (Properties)injector.getInstance(Properties.class);
        Assert.assertNotNull((Object)props);
        Assert.assertTrue((boolean)props.isEmpty());
        Assert.assertSame((Object)props, (Object)injector.getInstance(Properties.class));
    }

    @Test
    public void testExplicitProperties() {
        Properties props = new Properties();
        props.put("foo", "bar");
        Injector injector = new StartupInjectorBuilder().forTests().withProperties(props).build();
        Properties propsInstance = (Properties)injector.getInstance(Properties.class);
        Assert.assertSame((Object)props, (Object)propsInstance);
    }

    @Test
    public void testExtensionsOption() {
        Properties props = new Properties();
        props.put("druid.extensions.directory", "bogus");
        props.put("druid.modules.excludeList", "[\"excluded\"]");
        Injector injector = new StartupInjectorBuilder().withExtensions().withProperties(props).build();
        Assert.assertEquals((Object)"bogus", (Object)((ExtensionsConfig)injector.getInstance(ExtensionsConfig.class)).getDirectory());
        Assert.assertEquals(Collections.singletonList("excluded"), (Object)((ModulesConfig)injector.getInstance(ModulesConfig.class)).getExcludeList());
    }
}

