/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.junit.Assert;
import org.junit.Test;

public class TaskStatusTest {
    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TaskStatus status = new TaskStatus("testId", TaskState.RUNNING, 1000L, "an error message", TaskLocation.create((String)"testHost", (int)1010, (int)-1));
        String json = mapper.writeValueAsString((Object)status);
        Assert.assertEquals((Object)status, (Object)mapper.readValue(json, TaskStatus.class));
        String jsonNoLocation = "{\n\"id\": \"testId\",\n\"status\": \"SUCCESS\",\n\"duration\": 3000,\n\"errorMsg\": \"hello\"\n}";
        TaskStatus statusNoLocation = new TaskStatus("testId", TaskState.SUCCESS, 3000L, "hello", null);
        Assert.assertEquals((Object)statusNoLocation, (Object)mapper.readValue("{\n\"id\": \"testId\",\n\"status\": \"SUCCESS\",\n\"duration\": 3000,\n\"errorMsg\": \"hello\"\n}", TaskStatus.class));
        TaskStatus success = TaskStatus.success((String)"forkTaskID", (TaskLocation)TaskLocation.create((String)"localhost", (int)0, (int)1));
        Assert.assertEquals((Object)success.getLocation().getHost(), (Object)"localhost");
        Assert.assertEquals((long)success.getLocation().getPort(), (long)0L);
        Assert.assertEquals((long)success.getLocation().getTlsPort(), (long)1L);
    }
}

